/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.security;

import eu.emi.emir.security.XACMLAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class SubjectAttributesHolder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, List<XACMLAttribute>> xacmlAttributes;
    private Map<String, String[]> defaultIncarnationAttributes;
    private Map<String, String[]> validIncarnationAttributes;

    public SubjectAttributesHolder() {
        this.xacmlAttributes = new HashMap<String, List<XACMLAttribute>>();
        this.defaultIncarnationAttributes = new HashMap<String, String[]>();
        this.validIncarnationAttributes = new HashMap<String, String[]>();
    }

    public SubjectAttributesHolder(Map<String, String[]> incarnationAttributes) {
        this(null, incarnationAttributes, incarnationAttributes);
    }

    public SubjectAttributesHolder(Map<String, String[]> defaultIncarnationAttributes, Map<String, String[]> validIncarnationAttributes) {
        this(null, defaultIncarnationAttributes, validIncarnationAttributes);
    }

    public SubjectAttributesHolder(List<XACMLAttribute> xacmlAttributes, Map<String, String[]> defaultIncarnationAttributes, Map<String, String[]> validIncarnationAttributes) {
        this.setXacmlAttributes(xacmlAttributes);
        this.setAllIncarnationAttributes(defaultIncarnationAttributes, validIncarnationAttributes);
    }

    public void addAllOverwritting(SubjectAttributesHolder from) {
        if (from.getDefaultIncarnationAttributes() != null) {
            this.defaultIncarnationAttributes.putAll(from.getDefaultIncarnationAttributes());
        }
        if (from.getValidIncarnationAttributes() != null) {
            this.validIncarnationAttributes.putAll(from.getValidIncarnationAttributes());
        }
        if (from.getXacmlAttributes() != null) {
            for (XACMLAttribute xacmlAttribute : from.getXacmlAttributes()) {
                this.xacmlAttributes.remove(xacmlAttribute.getName());
            }
            for (XACMLAttribute xacmlAttribute : from.getXacmlAttributes()) {
                this.addToXACMLList(xacmlAttribute);
            }
        }
    }

    public void addAllMerging(SubjectAttributesHolder from) {
        if (from.getDefaultIncarnationAttributes() != null) {
            this.defaultIncarnationAttributes.putAll(from.getDefaultIncarnationAttributes());
        }
        if (from.getValidIncarnationAttributes() != null) {
            for (Map.Entry entry : from.getValidIncarnationAttributes().entrySet()) {
                String key = (String)entry.getKey();
                String[] existing = this.validIncarnationAttributes.get(key);
                String[] newAttr = (String[])entry.getValue();
                if (existing != null) {
                    LinkedHashSet<String> result = new LinkedHashSet<String>();
                    for (String existingA : existing) {
                        result.add(existingA);
                    }
                    for (String newA : newAttr) {
                        result.add(newA);
                    }
                    this.validIncarnationAttributes.put(key, result.toArray(new String[result.size()]));
                    continue;
                }
                this.validIncarnationAttributes.put(key, newAttr);
            }
        }
        if (from.getXacmlAttributes() != null) {
            for (XACMLAttribute xACMLAttribute : from.getXacmlAttributes()) {
                this.addToXACMLList(xACMLAttribute);
            }
        }
    }

    private void addToXACMLList(XACMLAttribute a) {
        List<XACMLAttribute> current = this.xacmlAttributes.get(a.getName());
        if (current == null) {
            current = new ArrayList<XACMLAttribute>();
            this.xacmlAttributes.put(a.getName(), current);
        }
        if (!current.contains(a)) {
            current.add(a);
        }
    }

    public List<XACMLAttribute> getXacmlAttributes() {
        ArrayList<XACMLAttribute> ret = new ArrayList<XACMLAttribute>();
        Collection<List<XACMLAttribute>> vals = this.xacmlAttributes.values();
        for (List<XACMLAttribute> val : vals) {
            ret.addAll(val);
        }
        return ret;
    }

    public void setXacmlAttributes(List<XACMLAttribute> xacmlAttributes) {
        this.xacmlAttributes = new HashMap<String, List<XACMLAttribute>>();
        if (xacmlAttributes != null) {
            for (XACMLAttribute a : xacmlAttributes) {
                this.addToXACMLList(a);
            }
        }
    }

    public Map<String, String[]> getDefaultIncarnationAttributes() {
        return this.defaultIncarnationAttributes;
    }

    public Map<String, String[]> getValidIncarnationAttributes() {
        return this.validIncarnationAttributes;
    }

    public void setAllIncarnationAttributes(Map<String, String[]> defaultIncarnationAttributes, Map<String, String[]> validIncarnationAttributes) {
        if (defaultIncarnationAttributes == null || validIncarnationAttributes == null) {
            throw new IllegalArgumentException("Arguments can not be null");
        }
        for (Map.Entry<String, String[]> defA : defaultIncarnationAttributes.entrySet()) {
            if (validIncarnationAttributes.containsKey(defA.getKey())) {
                String[] defaultVals;
                String[] validVals = validIncarnationAttributes.get(defA.getKey());
                for (String defaultVal : defaultVals = defA.getValue()) {
                    boolean found = false;
                    for (String validVal : validVals) {
                        if (!validVal.equals(defaultVal)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new IllegalArgumentException("The default incarnation attribute >" + defA.getKey() + "< value >" + defaultVal + "< is not present among valid incarnation attributes.");
                }
                continue;
            }
            throw new IllegalArgumentException("The default incarnation attribute " + defA.getKey() + " is not present among valid incarnation attributes.");
        }
        this.defaultIncarnationAttributes = new HashMap<String, String[]>();
        this.defaultIncarnationAttributes.putAll(defaultIncarnationAttributes);
        this.validIncarnationAttributes = new HashMap<String, String[]>();
        this.validIncarnationAttributes.putAll(validIncarnationAttributes);
    }

    public boolean isPresent() {
        if (this.defaultIncarnationAttributes.size() > 0) {
            return true;
        }
        return this.xacmlAttributes.size() > 0;
    }

    private static void outputAttrsMap(StringBuilder sb, Map<String, String[]> attrs) {
        Iterator<Map.Entry<String, String[]>> valid = attrs.entrySet().iterator();
        while (valid.hasNext()) {
            Map.Entry<String, String[]> validE = valid.next();
            sb.append(validE.getKey());
            sb.append(": ");
            sb.append(Arrays.toString(validE.getValue()));
            if (!valid.hasNext()) continue;
            sb.append("; ");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        boolean needEnter = false;
        if (this.validIncarnationAttributes.size() != 0) {
            sb.append("Valid attribute values: ");
            SubjectAttributesHolder.outputAttrsMap(sb, this.validIncarnationAttributes);
            needEnter = true;
        }
        if (this.defaultIncarnationAttributes.size() != 0) {
            if (needEnter) {
                sb.append("\n");
            }
            sb.append("Default attribute values: ");
            SubjectAttributesHolder.outputAttrsMap(sb, this.defaultIncarnationAttributes);
            needEnter = true;
        }
        if (this.xacmlAttributes.size() > 0) {
            if (needEnter) {
                sb.append("\n");
            }
            sb.append("XACML authorization attributes: ");
            for (Map.Entry<String, List<XACMLAttribute>> validE : this.xacmlAttributes.entrySet()) {
                sb.append(validE.getValue());
            }
        }
        return sb.toString();
    }
}

