/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.security;

import eu.emi.emir.client.util.Log;
import eu.emi.emir.pdp.RegistryPDP;
import eu.emi.emir.pdp.local.AcceptingPDP;
import eu.emi.emir.security.DefaultServerSecurityConfiguration;
import eu.emi.emir.security.IAttributeSource;
import eu.emi.emir.security.SecurityManager;
import eu.emi.emir.security.util.AttributeSourcesChain;
import eu.unicore.security.canl.AuthnAndTrustProperties;
import eu.unicore.security.canl.IAuthnAndTrustConfiguration;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ServerSecurityProperties
extends DefaultServerSecurityConfiguration {
    private static final Logger logger = Log.getLogger((String)"emir.security", ServerSecurityProperties.class);
    public static final String SECURITY_PREFIX = "security.";
    @DocumentationReferencePrefix
    public static final String PREFIX = "emir.security.";
    public static final String PROP_SSL_ENABLED = "sslEnabled";
    public static final String PROP_CHECKACCESS = "accesscontrol";
    public static final String PROP_CHECKACCESS_PDP = "accesscontrol.pdp";
    public static final String PROP_CHECKACCESS_PDPCONFIG = "accesscontrol.pdpConfig";
    public static final String PROP_AIP_PREFIX = "attributes";
    public static final String PROP_AIP_ORDER = "attributes.order";
    private static final String PROP_AIP_COMBINING_POLICY = "attributes.combiningPolicy";
    public static final String PROP_CHECKACCESS_ACL = "accesscontrol.acl";
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();
    private PropertiesHelper properties;
    private Properties source;

    public ServerSecurityProperties(Properties p) throws Exception {
        this(p, null);
    }

    public ServerSecurityProperties(Properties source, IAuthnAndTrustConfiguration authAndTrust) throws Exception {
        boolean trustNeeded;
        boolean isHttps = source.getProperty("emir.address").startsWith("https");
        if (isHttps) {
            this.setSslEnabled(true);
        }
        this.source = source;
        this.properties = new PropertiesHelper(PREFIX, source, META, logger);
        if (this.isSslEnabled()) {
            if (this.properties.getValue(PROP_CHECKACCESS_ACL) != null) {
                this.setAclAccessControlEnabled(true);
            }
            if (this.properties.getValue(PROP_CHECKACCESS_PDPCONFIG) != null) {
                this.setXACMLAccessControlEnabled(true);
            }
            if (this.properties.getValue(PROP_CHECKACCESS_ACL) != null && this.properties.getValue(PROP_CHECKACCESS_PDPCONFIG) != null) {
                this.setAclAccessControlEnabled(true);
                this.setXACMLAccessControlEnabled(false);
            } else if (this.properties.getValue(PROP_CHECKACCESS_ACL) == null && this.properties.getValue(PROP_CHECKACCESS_PDPCONFIG) == null) {
                Log.logException((String)"Access control properties must be provided in the configuration file", (Throwable)new ConfigurationException(), (Logger)logger);
            }
        }
        boolean credNeeded = this.isSslEnabled();
        boolean bl = trustNeeded = this.isSslEnabled() || this.isXACMLAccessControlEnabled() || this.isACLAccessControlEnabled();
        if (authAndTrust == null) {
            authAndTrust = new AuthnAndTrustProperties(source, "emir.security.truststore.", "emir.security.credential.", !trustNeeded, !credNeeded);
        }
        if (this.isSslEnabled()) {
            this.setValidator(authAndTrust.getValidator());
            this.setCredential(authAndTrust.getCredential());
            if (this.isXACMLAccessControlEnabled()) {
                this.setAip(this.createAttributeSource(source));
                this.setPdp(this.createPDP(this.properties));
            }
            if (this.isACLAccessControlEnabled()) {
                this.setAclConfigurationFile(this.properties.getValue(PROP_CHECKACCESS_ACL));
            }
        }
    }

    public Properties getRawProperties() {
        return this.source;
    }

    private RegistryPDP createPDP(PropertiesHelper properties) {
        Class<?> pdpClazz;
        if (!this.isXACMLAccessControlEnabled()) {
            return new AcceptingPDP();
        }
        if (properties.isSet(PROP_CHECKACCESS_PDPCONFIG)) {
            String conf = properties.getValue(PROP_CHECKACCESS_PDPCONFIG);
            this.setPdpConfigFile(conf);
        }
        String pdpClass = properties.getValue(PROP_CHECKACCESS_PDP);
        try {
            pdpClazz = Class.forName(pdpClass);
        }
        catch (ClassNotFoundException cfe) {
            throw new ConfigurationException("Cannot load PDP class <" + pdpClass + ">: ", (Throwable)cfe);
        }
        try {
            Constructor<?> constructor = pdpClazz.getConstructor(String.class);
            logger.info((Object)("Using PDP class <" + pdpClass + ">"));
            RegistryPDP pdp = (RegistryPDP)constructor.newInstance(this.getPdpConfigurationFile());
            return pdp;
        }
        catch (Exception e) {
            throw new ConfigurationException("Can't create a PDP.", (Throwable)e);
        }
    }

    private IAttributeSource createAttributeSource(Properties raw) throws Exception {
        String order = this.properties.getValue(PROP_AIP_ORDER);
        if (order == null) {
            logger.info((Object)"No attribute source is defined in the configuration, users won't have any authorisation attributes assigned");
            return new SecurityManager.NullAuthoriser();
        }
        logger.debug((Object)"Creating main attribute sources chain");
        AttributeSourcesChain ret = new AttributeSourcesChain();
        ret.setCombiningPolicy(this.properties.getValue(PROP_AIP_COMBINING_POLICY));
        ret.setOrder(order);
        ret.setProperties(raw);
        ret.init(null);
        return ret;
    }

    @Override
    public boolean isAccessControlEnabled(String service) {
        return this.properties.getSubkeyBooleanValue(PROP_CHECKACCESS, service);
    }

    static {
        META.put(PROP_SSL_ENABLED, new PropertyMD("false").setDescription("Controls whether secure SSL mode is enabled.").setBoolean());
        META.put(PROP_CHECKACCESS, new PropertyMD("false").setDescription("Controls whether access checking (authorisation) is enabled."));
        META.put(PROP_CHECKACCESS_PDP, new PropertyMD("eu.emi.emir.pdp.local.LocalHerasafPDP").setDescription("Controls which Policy Decision Point (PDP, the authorisation engine) should be used."));
        META.put(PROP_CHECKACCESS_PDPCONFIG, new PropertyMD().setPath().setDescription("Path of the PDP configuration file"));
        META.put(PROP_AIP_ORDER, new PropertyMD("FILE").setDescription("Attribute sources in invocation order."));
        META.put(PROP_AIP_COMBINING_POLICY, new PropertyMD("MERGE_LAST_OVERRIDES").setDescription("What algorithm should be used for combining the attributes from multiple attribute sources (if more then one is defined)."));
        META.put(PROP_CHECKACCESS_ACL, new PropertyMD().setPath().setDescription("Path of the acl file. Enabling this would initiate ACL file based authorisation instead of XACML"));
        META.put(PROP_AIP_PREFIX, new PropertyMD().setCanHaveSubkeys().setDescription("blah blah prefix"));
        META.put("truststore.", new PropertyMD().setCanHaveSubkeys().setDescription("Properties with this prefix are used to configure container's trust settings and certificates validation. See separate documentation for details."));
        META.put("credential.", new PropertyMD().setCanHaveSubkeys().setDescription("Properties with this prefix are used to configure the credential used by the container. See separate documentation for details."));
    }
}

