/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.security;

import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.pdp.PDPResult;
import eu.emi.emir.pdp.RegistryPDP;
import eu.emi.emir.security.AttributeHandlingCallback;
import eu.emi.emir.security.AttributeSourceFactory;
import eu.emi.emir.security.AuthNCheckingStrategy;
import eu.emi.emir.security.AuthorisationException;
import eu.emi.emir.security.Client;
import eu.emi.emir.security.IAttributeSource;
import eu.emi.emir.security.Role;
import eu.emi.emir.security.SecurityTokens;
import eu.emi.emir.security.ServerSecurityProperties;
import eu.emi.emir.security.SubjectAttributesHolder;
import eu.emi.emir.security.UserAttributeCallback;
import eu.emi.emir.security.util.ResourceDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public final class SecurityManager {
    private static final Logger logger = Log.getLogger((String)"emir.security", SecurityManager.class);
    public static final String CLIENT = "client";
    public static final String DISABLE_SECURITY_AND_ACCESS_CONTROL = "registry.security.disable";
    private static RegistryPDP pdp = null;
    private static Boolean isAccessControlEnabled = null;
    private static Boolean isProxyModeEnabled = null;
    private static IAttributeSource attributeSource = null;
    private static X509Certificate serverCert = null;
    private static X509Certificate gatewayCert = null;
    private static List<AuthNCheckingStrategy> authNCheckStrategies = new ArrayList<AuthNCheckingStrategy>();
    private static Set<AttributeHandlingCallback> attribHandlingCallbacks = new HashSet<AttributeHandlingCallback>();
    private static final List<String> actionsRequiringSignatures = new ArrayList<String>();
    private static final ThreadLocal<Boolean> localCalls = new ThreadLocal();
    protected static final String proxyRE = "(CN=([\\d]+))|(CN=proxy)";
    public static final Pattern pattern = Pattern.compile("(CN=([\\d]+))|(CN=proxy)", 2);

    private SecurityManager() {
    }

    public static void addCallback(AttributeHandlingCallback aac) {
        attribHandlingCallbacks.add(aac);
    }

    public static X509Certificate getServerCert() {
        if (serverCert == null) {
            try {
                serverCert = EMIRServer.getServerSecurityProperties().getCredential().getCertificateChain()[0];
                logger.info((Object)("Server identity: " + serverCert.getSubjectX500Principal().toString()));
            }
            catch (Exception e) {
                Log.logException((String)"Could not get server certificate", (Throwable)e, (Logger)logger);
            }
        }
        return serverCert;
    }

    public static X500Principal getServerIdentity() {
        ServerSecurityProperties secProps = EMIRServer.getServerSecurityProperties();
        if (secProps.isSslEnabled() && secProps.getCredential() != null) {
            return SecurityManager.getServerCert().getSubjectX500Principal();
        }
        return null;
    }

    public static String getServerDistinguishedName() {
        X500Principal p = SecurityManager.getServerIdentity();
        return p != null ? SecurityManager.getServerIdentity().toString() : null;
    }

    public static synchronized RegistryPDP getPDP() {
        if (pdp == null) {
            pdp = EMIRServer.getServerSecurityProperties().getPdp();
        }
        return pdp;
    }

    public static SubjectAttributesHolder establishAttributes(SecurityTokens tokens) throws Exception {
        if (attributeSource == null) {
            SecurityManager.createAttributeSource();
        }
        return attributeSource.getAttributes(tokens, null);
    }

    public static synchronized void createAttributeSource() throws Exception {
        attributeSource = new AttributeSourceFactory(EMIRServer.getServerSecurityProperties().getRawProperties()).makeAttributeSource();
    }

    private static void handleRole(Client client, Map<String, String[]> preferences, Map<String, String[]> validAttributes, Map<String, String[]> defaultAttributes) {
        Role r = new Role();
        String[] validRoles = validAttributes.get("role");
        String[] defaultRole = defaultAttributes.get("role");
        if (defaultRole != null && defaultRole.length > 0) {
            String[] prefRole = preferences.get("role");
            if (prefRole != null && prefRole.length > 0) {
                boolean roleOk = false;
                for (String valid : validRoles) {
                    if (!valid.equals(prefRole[0])) continue;
                    r.setName(valid);
                    r.setDescription("user's preferred role");
                    roleOk = true;
                    break;
                }
                if (!roleOk) {
                    throw new SecurityException("Requested role <" + prefRole[0] + "> is not available.");
                }
            } else {
                r.setName(defaultRole[0]);
                r.setDescription("role from attribute source");
            }
        } else {
            r.setName("anonymous");
            r.setDescription("default role");
        }
        client.setRole(r);
    }

    private static void assembleClientAttributes(Client client, SecurityTokens tokens) {
        if (SecurityManager.isServer(client)) {
            Role r = SecurityManager.getServerRole();
            client.setRole(r);
        } else {
            Map<String, String[]> preferences;
            SubjectAttributesHolder subAttributes;
            try {
                subAttributes = SecurityManager.establishAttributes(tokens);
            }
            catch (Exception e) {
                throw new SecurityException("Exception when getting attributes for the client.", e);
            }
            if (subAttributes != null) {
                client.setSubjectAttributes(subAttributes);
            }
            if ((preferences = (Map<String, String[]>)tokens.getContext().get(UserAttributeCallback.USER_PREFERENCES_KEY)) == null) {
                preferences = Collections.emptyMap();
            }
            Map<String, String[]> validAttributes = client.getSubjectAttributes().getValidIncarnationAttributes();
            Map<String, String[]> defaultAttributes = client.getSubjectAttributes().getDefaultIncarnationAttributes();
            SecurityManager.handleRole(client, preferences, validAttributes, defaultAttributes);
        }
        for (AttributeHandlingCallback a : attribHandlingCallbacks) {
            Map<String, Serializable> attribs = a.extractAttributes(tokens);
            if (attribs == null) continue;
            client.getExtraAttributes().putAll(attribs);
        }
    }

    private static Client createSecureClient(SecurityTokens tokens) {
        Client client = new Client();
        String dn = null;
        if (dn == null) {
            dn = tokens.getUserName().toString();
        }
        client.setDistinguishedName(dn);
        client.setSecurityTokens(tokens);
        SecurityManager.assembleClientAttributes(client, tokens);
        return client;
    }

    public static Client createAndAuthoriseClient(SecurityTokens tokens) {
        Client client = new Client();
        client = SecurityManager.isLocalCall() ? SecurityManager.makeAnonymousClient("CN=Local_call") : (tokens == null ? SecurityManager.makeAnonymousClient(null) : (EMIRServer.getServerSecurityProperties().isXACMLAccessControlEnabled() ? SecurityManager.createSecureClient(tokens) : SecurityManager.makeAnonymousClient("CN=Security_is_disabled")));
        MDC.put((String)"clientName", (Object)client.getDistinguishedName());
        return client;
    }

    protected static Role getServerRole() {
        Role r = new Role();
        r.setDescription("Server");
        r.setName("__server__");
        return r;
    }

    protected static Client makeAnonymousClient(String dn) {
        Client c = new Client();
        if (dn == null) {
            c.setDistinguishedName("CN=ANONYMOUS,O=UNKNOWN,OU=UNKNOWN");
        } else {
            c.setDistinguishedName(dn);
        }
        c.setRole(new Role("anonymous", "No authorisation information available."));
        return c;
    }

    public static void checkAuthentication(SecurityTokens tokens, String action, ResourceDescriptor d) {
        for (AuthNCheckingStrategy s : authNCheckStrategies) {
            s.checkAuthentication(tokens, action, d);
        }
    }

    public static void registerAuthNCheckingStrategies(AuthNCheckingStrategy ... strategies) {
        authNCheckStrategies.addAll(Arrays.asList(strategies));
    }

    private static PDPResult.Decision checkAuthzInternal(Client c, String action, ResourceDescriptor d) {
        PDPResult res;
        try {
            res = SecurityManager.getPDP().checkAuthorisation(c, action, d);
        }
        catch (Exception e) {
            throw new AuthorisationException("Access denied due to PDP error: " + e);
        }
        if (res.getDecision().equals((Object)PDPResult.Decision.UNCLEAR)) {
            logger.warn((Object)"The EMI Registry PDP was unable to make a definitive decision, check your policy files and consult other log messages.");
        }
        return res.getDecision();
    }

    public static void checkAuthorisation(Client c, String action, ResourceDescriptor d) throws AuthorisationException {
        PDPResult.Decision decision = SecurityManager.checkAuthzInternal(c, action, d);
        if (!decision.equals((Object)PDPResult.Decision.PERMIT)) {
            String msg = "Access denied for " + c.getDistinguishedName() + " on resource " + d;
            logger.info((Object)msg);
            throw new AuthorisationException(msg);
        }
    }

    public static boolean isAccessible(Client client, String serviceName, String wsResourceID, String owner) throws Exception {
        if (!SecurityManager.isAccessControlEnabled()) {
            return true;
        }
        if (SecurityManager.isServer(client)) {
            return true;
        }
        ResourceDescriptor resource = new ResourceDescriptor(serviceName, wsResourceID, owner);
        PDPResult.Decision decision = SecurityManager.checkAuthzInternal(client, null, resource);
        return decision.equals((Object)PDPResult.Decision.PERMIT);
    }

    public static void setLocalCall() {
        localCalls.set(Boolean.TRUE);
    }

    public static void clearLocalCall() {
        localCalls.set(null);
    }

    public static boolean isLocalCall() {
        return Boolean.TRUE.equals(localCalls.get());
    }

    public static boolean isServer(Client c) {
        try {
            if (c == null) {
                return false;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Check server=<" + SecurityManager.getServerCert().getSubjectX500Principal().getName() + "> " + " vs client=<" + c.getDistinguishedName() + ">"));
            }
            if (SecurityManager.getServerDistinguishedName().equals(c.getDistinguishedName())) {
                return true;
            }
        }
        catch (Exception e) {
            Log.logException((String)"Could not check certificate vs. server cert.", (Throwable)e, (Logger)logger);
        }
        return false;
    }

    public static boolean isServer(X509Certificate cert) {
        return SecurityManager.getServerCert().equals(cert);
    }

    public static boolean isServer(CertPath path) {
        try {
            X509Certificate cert = (X509Certificate)path.getCertificates().get(0);
            if (SecurityManager.getServerCert().equals(cert)) {
                return true;
            }
        }
        catch (Exception e) {
            Log.logException((String)"Could not check certificate vs. server cert", (Throwable)e, (Logger)logger);
        }
        return false;
    }

    public static boolean isAdmin(Client c) {
        try {
            return "admin".equals(c.getRole().getName());
        }
        catch (Exception e) {
            Log.logException((String)"Could not check whether client is admin.", (Throwable)e, (Logger)logger);
            return false;
        }
    }

    public static boolean isAccessControlEnabled() {
        isAccessControlEnabled = EMIRServer.getServerSecurityProperties().isXACMLAccessControlEnabled();
        return isAccessControlEnabled;
    }

    public static synchronized String getAuthoriserConnectionStatus() throws Exception {
        if (attributeSource == null) {
            SecurityManager.createAttributeSource();
        }
        return attributeSource.getStatusDescription();
    }

    public static synchronized IAttributeSource getAtributeSource() throws Exception {
        if (attributeSource == null) {
            SecurityManager.createAttributeSource();
        }
        return attributeSource;
    }

    public static boolean isProxyDN(String dn) {
        return pattern.matcher(dn).find();
    }

    public static void addSOAPActionsRequiringSignatures(String ... actions) {
        actionsRequiringSignatures.addAll(Arrays.asList(actions));
    }

    public static boolean needSignature(String soapAction) {
        if (soapAction == null) {
            return false;
        }
        boolean b = actionsRequiringSignatures.contains(soapAction);
        logger.debug((Object)("Check <" + soapAction + "> = " + b));
        return b;
    }

    public static class NullAuthoriser
    implements IAttributeSource {
        @Override
        public String getStatusDescription() {
            return "(No attribute source configured)";
        }

        @Override
        public void init(String name) {
        }

        @Override
        public String getName() {
            return "NULL source";
        }

        @Override
        public SubjectAttributesHolder getAttributes(SecurityTokens tokens, SubjectAttributesHolder otherAuthoriserInfo) throws IOException {
            return new SubjectAttributesHolder();
        }

        @Override
        public String[] getAcceptedVOs() {
            return null;
        }
    }
}

