/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.security;

import eu.emi.emir.client.util.Log;
import eu.emi.emir.security.IAttributeSource;
import eu.emi.emir.security.SecurityManager;
import eu.emi.emir.security.util.AttributeSourcesChain;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AttributeSourceFactory {
    private static final Logger logger = Log.getLogger((String)"emir.security", AttributeSourceFactory.class);
    public static final String BASE = "emir.security.attributes";
    public static final String ORDER = "emir.security.attributes.order";
    public static final String COMBINING_POLICY = "emir.security.attributes.combiningPolicy";
    private final Properties properties;

    public AttributeSourceFactory(Properties properties) {
        this.properties = properties;
    }

    public IAttributeSource makeAttributeSource() throws Exception {
        IAttributeSource result;
        logger.debug((Object)"Creating main attribute sources chain");
        String order = this.properties.getProperty(ORDER);
        if (order != null) {
            AttributeSourcesChain ret = new AttributeSourcesChain();
            ret.setCombiningPolicy(this.properties.getProperty(COMBINING_POLICY));
            ret.setOrder(order);
            ret.setProperties(this.properties);
            ret.init(null);
            result = ret;
        } else {
            logger.info((Object)"No attribute source configured. Set the property <emir.security.attributes.order> to configure attribute sources.");
            result = new SecurityManager.NullAuthoriser();
        }
        return result;
    }
}

