/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.security;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.security.AuthorisationException;
import eu.emi.emir.security.Client;
import eu.emi.emir.security.SecurityManager;
import eu.emi.emir.security.SecurityTokens;
import eu.emi.emir.security.util.AuthZAttributeStore;
import eu.emi.emir.security.util.ResourceDescriptor;
import java.security.cert.CertPath;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

public class AccessControlFilter
implements ContainerRequestFilter {
    private static Logger logger = Log.getLogger((String)"emir.security", AccessControlFilter.class);
    @Context
    UriInfo uriInfo;
    @Context
    HttpServletRequest httpRequest;
    private static final String REALM = "HTTPS authentication";

    public ContainerRequest filter(ContainerRequest request) throws WebApplicationException {
        try {
            this.checkAccess();
        }
        catch (AuthorisationException e) {
            throw new WebApplicationException((Throwable)e, Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).entity((Object)("Error performing access control: \n" + e)).build());
        }
        return request;
    }

    protected void checkAccess() throws AuthorisationException {
        SecurityTokens tokens = null;
        Client client = null;
        String action = null;
        ResourceDescriptor resourceDescriptor = null;
        try {
            Boolean b = EMIRServer.getServerSecurityProperties().isSslEnabled();
            if (b.booleanValue()) {
                X509Certificate[] certArr = (X509Certificate[])this.httpRequest.getAttribute("javax.servlet.request.X509Certificate");
                tokens = new SecurityTokens();
                CertPath cp = CertificateFactory.getInstance("X.509").generateCertPath(Arrays.asList(certArr));
                tokens.setUser(cp);
                tokens.setUserName(certArr[0].getSubjectX500Principal());
                client = SecurityManager.createAndAuthoriseClient(tokens);
                this.httpRequest.setAttribute("client", (Object)client);
                if (EMIRServer.getServerSecurityProperties().isXACMLAccessControlEnabled()) {
                    AuthZAttributeStore.setTokens(tokens);
                    AuthZAttributeStore.setClient(client);
                    action = this.httpRequest.getMethod();
                    String owner = SecurityManager.getServerIdentity().getName();
                    resourceDescriptor = new ResourceDescriptor(this.uriInfo.getPath(), null, owner);
                    this.doCheck(tokens, client, action, resourceDescriptor);
                }
            }
        }
        catch (Exception e) {
            Log.logException((String)"Error setting up authorisation check", (Throwable)e, (Logger)logger);
            AuthZAttributeStore.removeClient();
            AuthZAttributeStore.removeTokens();
            AuthorisationException ae = new AuthorisationException("Authorisation failed. Reason: " + e.getMessage(), e);
            Response res = Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).entity((Object)("Error performing access control or Unauthorised access: \n" + e)).build();
            throw new WebApplicationException((Throwable)ae, res);
        }
    }

    protected void doCheck(SecurityTokens securityTokens, Client client, String action, ResourceDescriptor rd) throws WebApplicationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking access on service " + rd));
        }
        if (SecurityManager.isServer(client)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Accept server-scope action <" + action + "> on " + rd));
            }
            return;
        }
        SecurityManager.checkAuthentication(securityTokens, action, rd);
        SecurityManager.checkAuthorisation(client, action, rd);
    }
}

