/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.resource;

import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.core.ServiceColManager;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/status")
public class StatusResource {
    private static final Logger logger = Log.getLogger((String)"emir.httpserver", StatusResource.class);
    private String serverVersion = StatusResource.class.getPackage().getImplementationVersion();

    @GET
    @Produces(value={"application/json", "text/plain"})
    public Response getServerStatus() throws WebApplicationException {
        JSONObject jo = new JSONObject();
        Date d = EMIRServer.getRunningSince();
        try {
            if (this.serverVersion != null && !this.serverVersion.isEmpty()) {
                jo.put("EMIRServerVersion", (Object)this.serverVersion);
            }
            jo.put("MongoDBVersion", (Object)EMIRServer.getMongoDBVersion());
            jo.put("JavaVersion", (Object)System.getProperty("java.version"));
            jo.put("OSName", (Object)System.getProperty("os.name"));
            jo.put("OSArchitecture", (Object)System.getProperty("os.arch"));
            jo.put("OSVersion", (Object)System.getProperty("os.version"));
            jo.put("MaxRecordInRequest", (Object)EMIRServer.getServerProperties().getMaxRecordInARequest());
            if (EMIRServer.getServerProperties().isGlobalEnabled().booleanValue()) {
                jo.put("EMIRServerComponentName", (Object)"Global Service Registry (GSR)");
            } else {
                jo.put("EMIRServerComponentName", (Object)"Domain Service Registry (DSR)");
            }
            if (EMIRServer.getServerProperties().isAnonymousAccessEnabled().booleanValue()) {
                jo.put("AnonymousAccessPortNumber", (Object)EMIRServer.getServerProperties().getAnonymousPortNumber());
            }
            jo.put("RunningSince", (Object)d.toString());
            jo.put("NumberofEntries", (Object)new ServiceColManager().getTotalNumberOfEntries());
        }
        catch (JSONException e) {
            Log.logException((String)"Error in probing the EMIR status", (Throwable)e, (Logger)logger);
            throw new WebApplicationException((Throwable)e);
        }
        return Response.ok((Object)jo).build();
    }
}

