/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.resource;

import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.db.mongodb.MongoDBServiceDatabase;
import eu.emi.emir.util.ExceptionUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;

@Path(value="/services/facet")
public class FacetQueryResource {
    private static final Logger logger = Log.getLogger((String)"emir.core", FacetQueryResource.class);
    public static final Set<String> DEFAULT_NAMES;
    public static final String PARAM_FACET_NAMES = "names";

    @GET
    @Produces(value={"application/json"})
    public Response getFacets(@Context UriInfo ui) throws WebApplicationException {
        MongoDBServiceDatabase sd = new MongoDBServiceDatabase();
        JSONArray ja = new JSONArray();
        MultivaluedMap queryParams = ui.getQueryParameters();
        Set setNames = queryParams.keySet();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String k : setNames) {
            map.put(k, (String)queryParams.getFirst((Object)k));
        }
        try {
            ja = sd.facetedQuery(map);
        }
        catch (Exception e) {
            Log.logException((String)"Error in executing faceted query", (Throwable)e, (Logger)logger);
            ja.put((Object)ExceptionUtil.toJson(e));
            Response resp = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            throw new WebApplicationException((Throwable)e, resp);
        }
        return Response.ok((Object)ja).build();
    }

    static {
        HashSet<String> names = new HashSet<String>();
        names.add(ServiceBasicAttributeNames.SERVICE_ENDPOINT_CAPABILITY.toString());
        names.add(ServiceBasicAttributeNames.SERVICE_TYPE.toString());
        DEFAULT_NAMES = Collections.unmodifiableSet(names);
    }
}

