/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.pdp.local;

import eu.emi.emir.client.util.Log;
import eu.emi.emir.pdp.PDPResult;
import eu.emi.emir.pdp.RegistryPDP;
import eu.emi.emir.pdp.local.LocalPolicyStore;
import eu.emi.emir.pdp.local.PolicyListener;
import eu.emi.emir.pdp.local.RequestCreator;
import eu.emi.emir.security.Client;
import eu.emi.emir.security.util.ResourceDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.api.PDP;
import org.herasaf.xacml.core.api.PolicyRetrievalPoint;
import org.herasaf.xacml.core.context.RequestCtx;
import org.herasaf.xacml.core.context.ResponseCtx;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.context.impl.MissingAttributeDetailType;
import org.herasaf.xacml.core.context.impl.ResultType;
import org.herasaf.xacml.core.context.impl.StatusDetailType;
import org.herasaf.xacml.core.context.impl.StatusType;
import org.herasaf.xacml.core.converter.URNToPolicyCombiningAlgorithmConverter;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.simplePDP.OrderedMapBasedSimplePolicyRepository;
import org.herasaf.xacml.core.simplePDP.SimplePDPConfiguration;
import org.herasaf.xacml.core.simplePDP.SimplePDPFactory;
import org.xml.sax.SAXException;

public class LocalHerasafPDP
implements RegistryPDP,
PolicyListener {
    private static final Logger log = Log.getLogger((String)"emir.security", LocalHerasafPDP.class);
    private PDP engine;
    private RequestCreator requestMaker;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public LocalHerasafPDP(String configurationFile) throws IOException, SyntaxException, JAXBException, SAXException {
        this.requestMaker = new RequestCreator();
        new LocalPolicyStore(this, configurationFile);
    }

    @Override
    public void updateConfiguration(List<Evaluatable> policies, String algorithm) {
        SimplePDPConfiguration config = new SimplePDPConfiguration();
        URNToPolicyCombiningAlgorithmConverter policyCnv = new URNToPolicyCombiningAlgorithmConverter();
        OrderedMapBasedSimplePolicyRepository repo = new OrderedMapBasedSimplePolicyRepository();
        repo.deploy(policies);
        config.setRootCombiningAlgorithm(policyCnv.unmarshal(algorithm));
        config.setPolicyRetrievalPoint((PolicyRetrievalPoint)repo);
        this.lock.writeLock().lock();
        this.engine = SimplePDPFactory.getSimplePDP((SimplePDPConfiguration)config);
        this.lock.writeLock().unlock();
    }

    private ResponseCtx authorize(RequestCtx request) {
        this.lock.readLock().lock();
        ResponseCtx resp = this.engine.evaluate(request);
        this.lock.readLock().unlock();
        return resp;
    }

    @Override
    public PDPResult checkAuthorisation(Client c, String action, ResourceDescriptor d) throws Exception {
        List results;
        RequestCtx request = this.requestMaker.createRequest(c, action, d);
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            request.marshal((OutputStream)baos);
            log.debug((Object)("XACML request:" + baos.toString()));
        }
        ResponseCtx response = this.authorize(request);
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            response.marshal((OutputStream)baos);
            log.debug((Object)("XACML response:" + baos.toString()));
        }
        if ((results = response.getResponse().getResults()).size() != 1) {
            throw new Exception("XACML herasAF PDP BUG: got " + results.size() + " results after asking about one resource. Should get 1.");
        }
        ResultType result = (ResultType)results.get(0);
        return new PDPResult(LocalHerasafPDP.getDecision(result), LocalHerasafPDP.getComment(result));
    }

    private static PDPResult.Decision getDecision(ResultType result) {
        if (result.getDecision().equals((Object)DecisionType.DENY)) {
            return PDPResult.Decision.DENY;
        }
        if (result.getDecision().equals((Object)DecisionType.PERMIT)) {
            return PDPResult.Decision.PERMIT;
        }
        return PDPResult.Decision.UNCLEAR;
    }

    private static String getComment(ResultType result) {
        List mas;
        StatusDetailType detail;
        String m;
        StatusType status = result.getStatus();
        if (status == null) {
            return "";
        }
        StringBuilder msg = new StringBuilder();
        if (status.getStatusCode() != null) {
            msg.append("Decision status code: [");
            msg.append(status.getStatusCode().getValue() + "]\n");
        }
        if ((m = status.getStatusMessage()) != null) {
            msg.append("Message: [" + m + "]\n");
        }
        if ((detail = status.getStatusDetail()) != null && (mas = detail.getMissingAttributeDetails()) != null) {
            msg.append("The following attributes are missing: [");
            for (MissingAttributeDetailType ma : mas) {
                msg.append(" " + ma.getAttributeId());
            }
            msg.append(" ]");
        }
        return msg.toString().trim();
    }
}

