/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.pdp;

import eu.emi.emir.security.Client;
import java.util.HashSet;
import java.util.Set;

public class PDPUtils {
    public static final String LOCAL_SUBJECT_ROLE_ATTR = "role";
    public static final String LOCAL_SUBJECT_CONSIGNOR_ATTR = "consignor";
    public static final String LOCAL_SUBJECT_VO_ATTR = "vo";
    public static final String LOCAL_OWNER_ATTR = "owner";
    public static final String LOCAL_WSR_ATTR = "urn:unicore:wsresource";
    private static Set<String> reservedAttrs = new HashSet<String>();

    public static void validateClient(Client c) throws IllegalArgumentException {
        if (c.getDistinguishedName() == null) {
            throw new IllegalArgumentException("Subject DN is not available in authZ subsystem");
        }
        if (c.getRole() == null) {
            throw new IllegalArgumentException("Subject's role is not available in authZ subsystem");
        }
        if (c.getRole().getName() == null) {
            throw new IllegalArgumentException("Subject's role name is not available in authZ subsystem");
        }
    }

    public static boolean checkGenericAttr(String name) {
        return !reservedAttrs.contains(name);
    }

    static {
        reservedAttrs.add(LOCAL_OWNER_ATTR);
        reservedAttrs.add(LOCAL_SUBJECT_CONSIGNOR_ATTR);
        reservedAttrs.add(LOCAL_SUBJECT_ROLE_ATTR);
        reservedAttrs.add(LOCAL_SUBJECT_VO_ATTR);
        reservedAttrs.add(LOCAL_WSR_ATTR);
    }
}

