/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.p2p;

import com.mongodb.MongoException;
import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.util.DateUtil;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.db.mongodb.MongoDBServiceDatabase;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ValidityCheck
implements Runnable {
    private static Logger logger = Log.getLogger((String)"emir.core", ValidityCheck.class);
    private int etvalid;
    private int timedelay;
    private MongoDBServiceDatabase mongoDB;

    public ValidityCheck(int delay) {
        this.timedelay = delay;
        this.mongoDB = new MongoDBServiceDatabase();
        try {
            this.etvalid = EMIRServer.getServerProperties().getIntValue("global.etValid");
            if (this.etvalid < 12) {
                logger.info((Object)("Configured etvalid value (" + this.etvalid + ") is very low. Min value: 12 Default value will be used."));
                this.etvalid = 12;
            }
            logger.info((Object)("Set the etvalid to " + this.etvalid));
        }
        catch (NumberFormatException e) {
            logger.info((Object)"Set the default (12hours) value of etvalid.");
            this.etvalid = 12;
        }
    }

    @Override
    public void run() {
        while (true) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Soft-State thread (validity) started");
            }
            JSONObject currentTime = DateUtil.setExpiryTimeWithHours((JSONObject)new JSONObject(), (Integer)this.timedelay);
            try {
                String query = "{ \"Service_ExpireOn\" : { $lt: " + currentTime.getString("Service_ExpireOn") + "} }";
                logger.info((Object)query);
                this.mongoDB.findAndDelete(query);
            }
            catch (MongoException e) {
                logger.warn((Object)e.getCause());
            }
            catch (JSONException e) {
                logger.warn((Object)e.getCause());
            }
            try {
                Thread.sleep(this.etvalid * 60 * 60 * 1000);
                continue;
            }
            catch (InterruptedException e) {
                Log.logException((String)"", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

