/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.p2p;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.EMIRClient;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.DateUtil;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.security.SecurityManager;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class SelfRegistration
implements Runnable {
    private static Logger logger = Log.getLogger((String)"emir.core", SelfRegistration.class);
    private final WebResource selfRegisterClient;
    private JSONObject myInfos;
    private Boolean firstUsage;

    public SelfRegistration(String myUrl) throws Throwable {
        EMIRClient sc = new EMIRClient(myUrl + "/serviceadmin");
        if (EMIRServer.getServerSecurityProperties().isSslEnabled()) {
            sc = new EMIRClient(myUrl + "/serviceadmin", (IClientConfiguration)EMIRServer.getClientSecurityProperties());
        }
        this.selfRegisterClient = sc.getClientResource();
        this.firstUsage = true;
        try {
            URL tmp = new URL(myUrl);
            if (tmp.getProtocol().isEmpty()) {
                logger.error((Object)"The registry.scheme element is empty in the configuration!");
                this.finalize();
            }
            if (tmp.getHost().isEmpty()) {
                logger.error((Object)"The registry.hostname element is empty in the configuration!");
                this.finalize();
            }
            if (tmp.getHost().equals("localhost")) {
                logger.error((Object)"You added 'localhost' value in the registry.hostname element. Please modified it to the real DNS name or IP address!");
                this.finalize();
            }
            if (tmp.getPort() == -1) {
                logger.error((Object)"The registry.post element is empty in the configuration!");
                this.finalize();
            }
        }
        catch (MalformedURLException e) {
            Log.logException((String)"", (Throwable)e);
        }
        this.myInfos = new JSONObject();
        this.myInfos.put(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName(), (Object)myUrl);
        this.myInfos.put("Service_Name", (Object)"EMI IndexService");
        this.myInfos.put("Service_Type", (Object)"GSR");
        this.myInfos.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)myUrl);
        this.myInfos.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName(), (Object)myUrl);
        JSONArray capability = new JSONArray();
        capability.put((Object)"information.model");
        capability.put((Object)"information.discovery");
        this.myInfos.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_CAPABILITY.getAttributeName(), (Object)capability);
        this.myInfos.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_TECHNOLOGY.getAttributeName(), (Object)"webservice");
        String ifaceName = "http";
        if (myUrl.substring(0, 5).equals("https")) {
            ifaceName = ifaceName + "s";
        }
        this.myInfos.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACENAME.getAttributeName(), (Object)ifaceName);
        this.myInfos.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACE_VER.getAttributeName(), (Object)"1.0.0");
        try {
            String DN = SecurityManager.getServerDistinguishedName();
            this.myInfos.put(ServiceBasicAttributeNames.SERVICE_DN.getAttributeName(), (Object)DN);
            logger.info((Object)("Server's DN: " + DN));
        }
        catch (NullPointerException e) {
            logger.error((Object)"No DN. Please turn on the SSL with registry.scheme=https!");
        }
        JSONObject date = new JSONObject();
        date.put("$date", (Object)DateUtil.toUTCFormat((Date)new Date()));
        this.myInfos.put(ServiceBasicAttributeNames.SERVICE_CREATED_ON.getAttributeName(), (Object)date);
        this.myInfos.put(ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.getAttributeName(), (Object)date);
    }

    @Override
    public void run() {
        while (true) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"self registration entry");
            }
            DateUtil.setExpiryTime((JSONObject)this.myInfos, (Integer)EMIRServer.getServerProperties().getIntValue("record.expiryDefault"));
            JSONArray message = new JSONArray();
            message.put((Object)this.myInfos);
            try {
                ClientResponse res;
                if (this.firstUsage.booleanValue()) {
                    res = (ClientResponse)this.selfRegisterClient.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(ClientResponse.class, (Object)message);
                    if (res.getStatus() != Response.Status.BAD_REQUEST.getStatusCode()) {
                        this.firstUsage = false;
                    }
                } else {
                    res = (ClientResponse)this.selfRegisterClient.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(ClientResponse.class, (Object)message);
                    if (res.getStatus() == Response.Status.BAD_REQUEST.getStatusCode()) {
                        this.firstUsage = true;
                    }
                }
            }
            catch (ClientHandlerException e) {
                logger.trace((Object)("Self-registration problem: " + e.getMessage()));
            }
            try {
                Thread.sleep(3600000L);
                continue;
            }
            catch (InterruptedException e) {
                Log.logException((String)"", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

