/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.p2p;

import com.mongodb.MongoException;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.EMIRClient;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.core.ServiceAdminManager;
import eu.emi.emir.db.ExistingResourceException;
import eu.emi.emir.db.PersistentStoreFailureException;
import eu.emi.emir.db.QueryException;
import eu.emi.emir.db.ServiceDatabase;
import eu.emi.emir.db.mongodb.MongoDBServiceDatabase;
import eu.emi.emir.validator.InvalidServiceDescriptionException;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import javax.ws.rs.core.MediaType;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class NeighborsManager {
    private static Logger logger = Log.getLogger((String)"emir.core", NeighborsManager.class);
    private static NeighborsManager instance = null;
    private List<String> neighbors = new ArrayList<String>();
    private List<String> unavailableNeighbors = new ArrayList<String>();
    private ArrayList<String> infoProviders;
    int neighbors_count = 0;
    private Hashtable<String, String> hash;
    private ServiceDatabase serviceDB = null;
    private String myURL = EMIRServer.getServerProperties().getValue("address");
    private List<String> providerListURL;
    private int sparsity;
    private int retry;
    private boolean dowloadedProviderList;
    private boolean connected;
    private int maxEntriesNr;

    protected NeighborsManager() {
        this.hash = new Hashtable();
        this.serviceDB = new MongoDBServiceDatabase();
        this.providerListURL = this.GetInfoProvidersFromConfiguration();
        if (this.providerListURL.isEmpty()) {
            logger.warn((Object)"Configured providerlist value is empty. Please set it!");
        }
        try {
            this.sparsity = EMIRServer.getServerProperties().getIntValue("global.sparsity");
            if (this.sparsity < 2) {
                logger.info((Object)("Configured sparsity value (" + this.sparsity + ") is very low. Min value: 2 Default value will be used."));
                this.sparsity = 2;
            }
            logger.info((Object)("Set the sparsity to " + this.sparsity));
        }
        catch (NumberFormatException e) {
            logger.info((Object)"Set the default (2) value of sparsity.");
            this.sparsity = 2;
        }
        try {
            this.retry = EMIRServer.getServerProperties().getIntValue("global.retry");
            if (this.retry < 1) {
                logger.info((Object)("Configured retry value (" + this.retry + ") is very low. Min value: 1 Default value will be used."));
                this.retry = 5;
            }
            logger.info((Object)("Set the retry to " + this.retry));
        }
        catch (NumberFormatException e) {
            logger.info((Object)"Set the default (5) value of retry.");
            this.retry = 5;
        }
        this.dowloadedProviderList = false;
        this.infoProviders = this.DownloadProviderList(this.providerListURL);
        this.connected = false;
        this.maxEntriesNr = 1000;
        this.BootStrap(this.retry);
    }

    public static synchronized NeighborsManager getInstance() {
        if (instance == null) {
            instance = new NeighborsManager();
        }
        return instance;
    }

    public void hashClear() {
        this.hash.clear();
        this.neighbors_count = 0;
    }

    public int getRetry() {
        return this.retry;
    }

    public boolean getConnected() {
        return this.connected;
    }

    public synchronized List<String> getNeighbors() {
        if (!this.dowloadedProviderList) {
            this.infoProviders = this.DownloadProviderList(this.providerListURL);
        }
        if (this.dowloadedProviderList && !this.connected) {
            this.BootStrap(this.retry);
        }
        if (this.neighbors.isEmpty()) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(this.myURL);
            return tmp;
        }
        return this.neighbors;
    }

    public synchronized void addNeighborsDSRs(JSONArray entries, String type) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"addNeighborsDSRs called");
            logger.debug((Object)("hash: " + this.hash.toString()));
        }
        boolean updateNeed = false;
        if (type.equalsIgnoreCase("service_delete")) {
            updateNeed = true;
        } else {
            for (int i = 0; i < entries.length(); ++i) {
                try {
                    if (this.hash.containsValue(entries.getJSONObject(i).get(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName()))) continue;
                    updateNeed = true;
                    continue;
                }
                catch (JSONException e) {
                    logger.warn((Object)e.getCause());
                }
            }
        }
        if (updateNeed) {
            this.Neighbors_Update();
        }
    }

    public synchronized void setUnavailableNeighbor(String url) {
        logger.warn((Object)("Unavailable neighbor: " + url));
        if (!this.unavailableNeighbors.contains(url)) {
            this.unavailableNeighbors.add(url);
        }
        if (this.unavailableNeighbors.size() > this.neighbors_count / 2) {
            this.Neighbors_Update();
            this.unavailableNeighbors.clear();
        }
    }

    public synchronized void resetUnavailableNeighbor(String url) {
        if (this.unavailableNeighbors.remove(url) && logger.isDebugEnabled()) {
            logger.debug((Object)("Remove " + url + "from the list of unavailable GSR."));
        }
    }

    private void Neighbors_Update() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Neighbors_Update called");
        }
        JSONArray gsrList = new JSONArray();
        try {
            gsrList = this.serviceDB.queryJSON("{\"Service_Type\" : \"GSR\"}");
        }
        catch (MongoException e) {
            logger.warn((Object)e.getCause());
        }
        catch (QueryException e) {
            logger.warn((Object)e.getCause());
        }
        catch (PersistentStoreFailureException e) {
            logger.warn((Object)e.getCause());
        }
        catch (JSONException e) {
            logger.warn((Object)e.getCause());
        }
        if (this.connected && gsrList.length() < 2) {
            this.connected = false;
        }
        this.hash.clear();
        for (int i = 0; i < gsrList.length(); ++i) {
            try {
                String url = gsrList.getJSONObject(i).getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName());
                byte[] bytesOfMessage = url.getBytes("UTF-8");
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] digest = md.digest(bytesOfMessage);
                BigInteger bigInt = new BigInteger(1, digest);
                String hashtext = bigInt.toString(16);
                this.hash.put(hashtext, url);
                continue;
            }
            catch (JSONException e) {
                logger.warn((Object)e.getCause());
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                logger.warn((Object)e.getCause());
                continue;
            }
            catch (UnsupportedEncodingException e) {
                logger.warn((Object)e.getCause());
            }
        }
        int new_neighbors_count = 0;
        if (this.hash.size() > 0) {
            new_neighbors_count = (int)Math.ceil(Math.log10(this.hash.size()) / Math.log10(this.sparsity));
        }
        logger.info((Object)("Neighbors count recalculate from " + this.neighbors_count + " to " + new_neighbors_count));
        this.Neighbors_Calculate(new_neighbors_count);
        this.neighbors_count = new_neighbors_count;
    }

    private void Neighbors_Calculate(int count) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Neighbors_Calculate called");
        }
        Collection<String> c = this.hash.values();
        Iterator<String> itr = c.iterator();
        Iterator<String> itrFirst = c.iterator();
        while (itr.hasNext() && !itr.next().equals(this.myURL)) {
        }
        int sum_step = 1;
        int previous_step = 0;
        String currentEntry = "";
        this.neighbors.clear();
        for (int i = 0; i < count; ++i) {
            for (int step = 0; step < sum_step - previous_step; ++step) {
                if (!itr.hasNext()) {
                    itr = itrFirst;
                }
                currentEntry = itr.next();
            }
            previous_step = sum_step;
            sum_step *= this.sparsity;
            this.neighbors.add(currentEntry);
        }
    }

    private void BootStrap(int retry_count) {
        ArrayList<String> listOfGSRs = new ArrayList<String>();
        Collections.shuffle(this.infoProviders, new Random());
        for (int i = 0; i < this.infoProviders.size() && ((listOfGSRs = this.GSRList(this.infoProviders.get(i), retry_count)) == null || listOfGSRs.isEmpty()); ++i) {
        }
        listOfGSRs = this.GSRPriorities(listOfGSRs);
        this.GetDB(listOfGSRs, this.retry);
        this.Neighbors_Update();
    }

    private ArrayList<String> GSRList(String url, int retry) {
        EMIRClient c = new EMIRClient(url + "/services?Service_Type=GSR");
        if (EMIRServer.getServerSecurityProperties().isSslEnabled()) {
            c = new EMIRClient(url + "/services?Service_Type=GSR", (IClientConfiguration)EMIRServer.getClientSecurityProperties());
        }
        logger.info((Object)("Get the list of GSRs from " + url));
        for (int i = 0; i < retry; ++i) {
            JSONArray o;
            block7: {
                o = new JSONArray();
                try {
                    o = (JSONArray)c.getClientResource().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JSONArray.class);
                }
                catch (ClientHandlerException e) {
                    if (!logger.isDebugEnabled()) break block7;
                    logger.debug((Object)("Unreachable host: " + url));
                }
            }
            if (o.length() == 0) continue;
            ArrayList<String> listOfGSRs = new ArrayList<String>();
            for (int j = 0; j < o.length(); ++j) {
                try {
                    listOfGSRs.add(o.getJSONObject(j).getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName()));
                    continue;
                }
                catch (JSONException e) {
                    Log.logException((String)"", (Throwable)e);
                }
            }
            return listOfGSRs;
        }
        return null;
    }

    private ArrayList<String> GSRPriorities(ArrayList<String> list) {
        if (list == null) {
            list = new ArrayList();
        }
        if (list.removeAll(this.infoProviders)) {
            // empty if block
        }
        list.addAll(this.infoProviders);
        return list;
    }

    private void GetDB(ArrayList<String> list, int retry) {
        JSONArray newDB = new JSONArray();
        for (int j = 0; j < list.size(); ++j) {
            if (list.get(j).equals(this.myURL)) continue;
            String ref = null;
            String path = "/services/pagedquery?pageSize=" + this.maxEntriesNr;
            EMIRClient c = new EMIRClient(list.get(j) + path);
            if (EMIRServer.getServerSecurityProperties().isSslEnabled()) {
                c = new EMIRClient(list.get(j) + path, (IClientConfiguration)EMIRServer.getClientSecurityProperties());
            }
            boolean found = false;
            int state = 0;
            block6: while (ref == null && state == 0 || newDB.length() > 0 && !found && state != 3) {
                logger.info((Object)("Fetch DB from  " + list.get(j)));
                logger.debug((Object)("newDB: " + newDB.length() + ", found: " + found + ", state: " + state));
                for (int i = 0; i < retry; ++i) {
                    JSONArray o = new JSONArray();
                    try {
                        state = 1;
                        o = (JSONArray)c.getClientResource().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JSONArray.class);
                    }
                    catch (ClientHandlerException e) {
                        state = 3;
                        logger.debug((Object)("DB query, unreachable host: " + list.get(j)));
                        continue;
                    }
                    catch (UniformInterfaceException e) {
                        found = true;
                        continue block6;
                    }
                    state = 2;
                    if (o.length() != 0) {
                        try {
                            JSONObject refObj = o.getJSONObject(o.length() - 1);
                            ref = refObj.getString("ref");
                            logger.debug((Object)("New ref: " + ref));
                            newDB = new JSONArray();
                            for (int index = 0; index < o.length() - 1; ++index) {
                                newDB.put((Object)o.getJSONObject(index));
                            }
                            logger.debug((Object)("New DB: " + newDB.toString()));
                            if (!this.DBStore(newDB)) {
                                logger.warn((Object)"Some failure happend during the DB store.");
                            }
                            path = "/services/pagedquery?pageSize=" + this.maxEntriesNr + "&ref=" + ref;
                            c = new EMIRClient(list.get(j) + path);
                            if (!EMIRServer.getServerSecurityProperties().isSslEnabled()) continue block6;
                            c = new EMIRClient(list.get(j) + path, (IClientConfiguration)EMIRServer.getClientSecurityProperties());
                        }
                        catch (JSONException e) {
                            logger.debug((Object)("The got message is the last! message: " + o.toString()));
                            newDB = o;
                            logger.debug((Object)("New DB: " + newDB.toString()));
                            if (!this.DBStore(newDB)) {
                                logger.warn((Object)"Some failure happend during the DB store.");
                            }
                            found = true;
                        }
                        continue block6;
                    }
                    found = true;
                    continue block6;
                }
            }
            if (!found) continue;
            this.connected = true;
            break;
        }
    }

    private boolean DBStore(JSONArray newDB) {
        ServiceAdminManager serviceAdmin = new ServiceAdminManager();
        boolean retval = true;
        for (int i = 0; i < newDB.length(); ++i) {
            JSONObject jo = null;
            try {
                jo = new JSONObject(newDB.getString(i));
                String sendpointID = jo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName());
                if (sendpointID.equals(this.myURL)) continue;
                String messageTime = "";
                if (jo.has(ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName())) {
                    messageTime = jo.getJSONObject(ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName()).getString("$date");
                }
                if (!serviceAdmin.checkMessageGenerationTime(messageTime, sendpointID)) continue;
                JSONObject res = serviceAdmin.addService(jo);
                continue;
            }
            catch (JSONException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Some attribute(s) is/are missing: " + e.getMessage()));
                }
                retval = false;
                continue;
            }
            catch (InvalidServiceDescriptionException e) {
                Log.logException((String)"", (Throwable)e, (Logger)logger);
                retval = false;
                continue;
            }
            catch (ExistingResourceException e) {
                if (logger.isDebugEnabled()) {
                    logger.warn((Object)("This entry is exist in the DB: " + jo.toString()));
                }
                retval = false;
                continue;
            }
            catch (QueryException e) {
                Log.logException((String)"", (Throwable)e, (Logger)logger);
                retval = false;
                continue;
            }
            catch (PersistentStoreFailureException e) {
                Log.logException((String)"", (Throwable)e, (Logger)logger);
                retval = false;
                continue;
            }
            catch (Exception e) {
                Log.logException((String)"", (Throwable)e, (Logger)logger);
            }
        }
        return retval;
    }

    private ArrayList<String> DownloadProviderList(List<String> urls) {
        ArrayList<String> providers = new ArrayList<String>();
        for (int i = 0; i < urls.size(); ++i) {
            EMIRClient c = new EMIRClient(urls.get(i));
            if (EMIRServer.getServerSecurityProperties().isSslEnabled()) {
                c = new EMIRClient(urls.get(i), (IClientConfiguration)EMIRServer.getClientSecurityProperties());
            }
            try {
                String content = (String)c.getClientResource().accept(new String[]{"text/plain"}).get(String.class);
                content = content.replaceAll(" |\\[|\\]|\n", "");
                StringTokenizer tokens = new StringTokenizer(content, ",");
                while (tokens.hasMoreTokens()) {
                    providers.add((String)tokens.nextElement());
                }
                this.dowloadedProviderList = true;
                break;
            }
            catch (ClientHandlerException e) {
                this.dowloadedProviderList = false;
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Unreachable provider list from " + urls.get(i)));
                continue;
            }
        }
        return providers;
    }

    private List<String> GetInfoProvidersFromConfiguration() {
        ArrayList<String> listOfURLs = new ArrayList<String>();
        String configValue = EMIRServer.getServerProperties().getValue("global.providerList");
        try {
            configValue = configValue.replaceAll(" |\\[|\\]|\n", "");
        }
        catch (NullPointerException e) {
            return listOfURLs;
        }
        StringTokenizer tokens = new StringTokenizer(configValue, ",");
        while (tokens.hasMoreTokens()) {
            listOfURLs.add((String)tokens.nextElement());
        }
        return listOfURLs;
    }
}

