/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.p2p;

import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.core.RegistryThreadPool;
import eu.emi.emir.db.mongodb.MongoDBServiceDatabase;
import eu.emi.emir.event.Event;
import eu.emi.emir.p2p.NeighborsEventReciever;
import eu.emi.emir.p2p.RemoveCheck;
import eu.emi.emir.p2p.SelfRegistration;
import eu.emi.emir.p2p.ServiceEventReceiver;
import eu.emi.emir.p2p.ValidityCheck;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class GSRHelper {
    private static Logger logger = Log.getLogger((String)"emir.core", GSRHelper.class);

    public static void startGSRFunctions() {
        int timedelay;
        RegistryThreadPool.getExecutorService().execute(new NeighborsEventReciever());
        RegistryThreadPool.getExecutorService().execute(new ServiceEventReceiver());
        String myURL = EMIRServer.getServerProperties().getValue("address");
        try {
            RegistryThreadPool.getExecutorService().execute(new SelfRegistration(myURL));
        }
        catch (Throwable e) {
            logger.warn((Object)"Has a problem with the self-registration.");
        }
        try {
            timedelay = EMIRServer.getServerProperties().getIntValue("global.softStateDelay");
            if (timedelay < 0) {
                logger.info((Object)("Configured Soft-State timedelay value (" + timedelay + ") is very low. Min value: 0 Default value (2 hours) will be used."));
                timedelay = 2;
            }
            logger.info((Object)("Set the Soft-State timedelay to " + timedelay));
        }
        catch (NumberFormatException e) {
            logger.info((Object)"Set the default (2 hours) value of Soft-State timedelay.");
            timedelay = 2;
        }
        try {
            RegistryThreadPool.getExecutorService().execute(new ValidityCheck(timedelay));
        }
        catch (Throwable e) {
            logger.warn((Object)"Has a problem with the validity check.");
        }
        try {
            RegistryThreadPool.getExecutorService().execute(new RemoveCheck(timedelay));
        }
        catch (Throwable e) {
            logger.warn((Object)"Has a problem with the remove check.");
        }
    }

    public static void stopGSRFunctions() {
        logger.info((Object)"Send DELETE message to the neighbors.");
        String myURL = EMIRServer.getServerProperties().getValue("address");
        JSONObject eventData = new JSONObject();
        try {
            eventData.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)myURL);
        }
        catch (JSONException e) {
            Log.logException((String)"Error during the delete message sending ", (Throwable)e, (Logger)logger);
        }
        Event event = new Event("service_delete", eventData);
        try {
            new ServiceEventReceiver().recieve(event);
        }
        catch (Exception e) {
            Log.logException((String)"Error during the delete message sending ", (Throwable)e, (Logger)logger);
        }
        try {
            logger.info((Object)"Delete own entry from the database.");
            new MongoDBServiceDatabase().deleteByEndpointID(myURL);
        }
        catch (Exception e) {
            Log.logException((String)"Error in the delete procedure ", (Throwable)e, (Logger)logger);
        }
    }
}

