/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.jetty;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.jetty.EMIRJettyLogger;
import eu.emi.emir.jetty.EMIRJettyProperties;
import eu.emi.emir.security.ServerSecurityProperties;
import eu.unicore.security.canl.IAuthnAndTrustConfiguration;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.jetty.HttpServerProperties;
import eu.unicore.util.jetty.JettyServerBase;
import java.net.URL;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class JettyServer
extends JettyServerBase {
    private static final Logger logger = Log.getLogger((String)"unicore.httpserver", JettyServer.class);
    Map<String, String> jerseyParams = null;

    public JettyServer(URL listenUrl, ServerSecurityProperties securityCfg, EMIRJettyProperties jettyCfg, Map<String, String> map) throws Exception {
        super(listenUrl, (IAuthnAndTrustConfiguration)securityCfg, (HttpServerProperties)jettyCfg);
        this.jerseyParams = map;
        this.initServer();
    }

    public JettyServer(URL[] listenUrl, ServerSecurityProperties securityCfg, EMIRJettyProperties jettyCfg, Map<String, String> map) throws Exception {
        super(listenUrl, (IAuthnAndTrustConfiguration)securityCfg, (HttpServerProperties)jettyCfg, EMIRJettyLogger.class);
        this.jerseyParams = map;
        this.initServer();
    }

    protected Handler createRootHandler() throws ConfigurationException {
        logger.info((Object)"Adding Jersey Application");
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)this.getServer(), "/", 1);
        ServletHolder sh = new ServletHolder(ServletContainer.class);
        sh.setInitParameters(this.jerseyParams);
        root.addServlet(sh, "/*");
        return root;
    }
}

