/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.jetty;

import com.sun.jersey.api.container.filter.GZIPContentEncodingFilter;
import eu.emi.emir.EMIRApplication;
import eu.emi.emir.ServerProperties;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.core.FileListener;
import eu.emi.emir.core.RegistryThreadPool;
import eu.emi.emir.infrastructure.InputFilter;
import eu.emi.emir.jetty.EMIRJettyProperties;
import eu.emi.emir.jetty.JettyServer;
import eu.emi.emir.security.ACLFilter;
import eu.emi.emir.security.AccessControlFilter;
import eu.emi.emir.security.ClientSecurityProperties;
import eu.emi.emir.security.ServerSecurityProperties;
import eu.unicore.util.configuration.FilePropertiesHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class HttpsServer {
    private static Logger logger = Log.getLogger((String)"emir.httpserver", HttpsServer.class);
    JettyServer server = null;
    ServerProperties serverProps = null;
    ServerSecurityProperties serverSecProps = null;
    ClientSecurityProperties clientSecProps = null;
    EMIRJettyProperties jettyProperties = null;
    Properties props = null;

    public HttpsServer(String propsFilePath) throws Exception {
        this(FilePropertiesHelper.load((String)propsFilePath));
    }

    public HttpsServer(Properties props) throws Exception {
        this.startLogConfigWatcher();
        String v = ServerProperties.class.getPackage().getImplementationVersion();
        logger.info((Object)"");
        logger.info((Object)"******************************************");
        logger.info((Object)"*    EMI Service Endpoint Registry");
        if (v != null) {
            logger.info((Object)("*    Version " + v));
        }
        logger.info((Object)"******************************************");
        logger.info((Object)"");
        if (props.getProperty("emir.address").startsWith("https")) {
            props.setProperty("emir.jetty.requireClientAuthn", "true");
            props.setProperty("emir.jetty.wantClientAuthn", "true");
            props.setProperty("emir.security.sslEnabled", "true");
        }
        this.serverSecProps = new ServerSecurityProperties(props);
        if (this.serverSecProps.isSslEnabled()) {
            this.clientSecProps = new ClientSecurityProperties(props, this.serverSecProps);
        }
        this.props = props;
        this.serverProps = new ServerProperties(props, this.serverSecProps.isSslEnabled());
        this.jettyProperties = new EMIRJettyProperties(props);
        String address = this.serverProps.getValue("address");
        URL[] url = new URL[]{new URL(address)};
        this.server = new JettyServer(url, this.serverSecProps, this.jettyProperties, this.getJerseyInitParams());
    }

    public void start() throws Exception {
        this.server.start();
    }

    private void startLogConfigWatcher() {
        final String logConfig = System.getProperty("log4j.configuration");
        final LogManager l = LogManager.getLogManager();
        if (logConfig == null) {
            logger.debug((Object)"No log4j config defined.");
            return;
        }
        PropertyConfigurator.configure((String)logConfig);
        try {
            l.readConfiguration(new FileInputStream(new File(logConfig)));
        }
        catch (SecurityException e) {
            Log.logException((String)"", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            Log.logException((String)"", (Throwable)e);
        }
        catch (IOException e) {
            Log.logException((String)"", (Throwable)e);
        }
        try {
            final File logProperties = logConfig.startsWith("file:") ? new File(new URI(logConfig)) : new File(logConfig);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    logger.info((Object)"LOG CONFIG MODIFIED, re-configuring.");
                    try {
                        PropertyConfigurator.configure((String)logConfig);
                        l.readConfiguration(new FileInputStream(logProperties));
                    }
                    catch (SecurityException e) {
                        System.err.println("Log configuration file <" + logConfig + "> invalid access.");
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("Log configuration file <" + logConfig + "> not found.");
                    }
                    catch (IOException e) {
                        System.err.println("Log configuration file <" + logConfig + "> is not readable.");
                    }
                }
            };
            FileListener fw = new FileListener(logProperties, r);
            RegistryThreadPool.getScheduledExecutorService().scheduleWithFixedDelay(fw, 5L, 5L, TimeUnit.SECONDS);
            logger.info((Object)("Monitoring log configuration at <" + logProperties.getAbsolutePath() + ">"));
        }
        catch (FileNotFoundException fex) {
            System.err.println("Log configuration file <" + logConfig + "> not found.");
        }
        catch (URISyntaxException use) {
            System.err.println("Not a valid URI: <" + logConfig + ">.");
        }
    }

    private Map<String, String> getJerseyInitParams() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("javax.ws.rs.Application", EMIRApplication.class.getCanonicalName());
        map.put("com.sun.jersey.spi.container.ContainerRequestFilters", this.getRequestFilters());
        map.put("com.sun.jersey.spi.container.ContainerResponseFilters", this.getResponseFilters());
        return map;
    }

    private String getResponseFilters() {
        StringBuilder sb = new StringBuilder();
        String s = this.serverProps.getValue("interceptors.response");
        sb.append(GZIPContentEncodingFilter.class.getName());
        if (s != null) {
            sb.append(";").append(s);
        }
        return sb.toString();
    }

    private String getRequestFilters() {
        StringBuilder sb = new StringBuilder();
        String s = this.serverProps.getValue("interceptors.request");
        if (this.serverSecProps.isSslEnabled()) {
            if (this.serverSecProps.getPdpConfigurationFile() != null) {
                sb.append(AccessControlFilter.class.getName()).append(";");
            } else {
                sb.append(ACLFilter.class.getName()).append(";");
            }
        }
        if (this.serverProps.getValue("record.blockList.incoming") != null) {
            sb.append(InputFilter.class.getName()).append(";");
        }
        sb.append(GZIPContentEncodingFilter.class.getName());
        if (s != null) {
            sb.append(";").append(s);
        }
        return sb.toString();
    }

    public ServerProperties getServerProps() {
        return this.serverProps;
    }

    public ServerSecurityProperties getServerSecProps() {
        return this.serverSecProps;
    }

    public ClientSecurityProperties getClientSecProps() {
        return this.clientSecProps;
    }

    public Properties getRawProperties() {
        return this.props;
    }

    public JettyServer getJettyServer() {
        return this.server;
    }
}

