/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.jetty;

import com.sun.jersey.api.container.filter.GZIPContentEncodingFilter;
import eu.emi.emir.EMIRAnonymousApplication;
import eu.emi.emir.ServerProperties;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.jetty.EMIRJettyProperties;
import eu.emi.emir.jetty.JettyServer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Server;

public class HttpServer {
    private static Logger logger = Log.getLogger((String)"emir.httpserver", HttpServer.class);
    ServerProperties serverProps = null;
    JettyServer server = null;

    public HttpServer(Properties props) throws Exception {
        this.serverProps = new ServerProperties(props, false);
        EMIRJettyProperties jettyProperties = new EMIRJettyProperties(props);
        String httpsServerAddress = this.serverProps.getValue("address");
        URL httpsServerUrl = new URL(httpsServerAddress);
        String port = this.serverProps.getValue("address.anonymousPort");
        String address = "http://" + httpsServerUrl.getHost() + ":" + port;
        URL[] url = new URL[]{new URL(address)};
        this.server = new JettyServer(url, null, jettyProperties, this.getJerseyInitParams());
    }

    public void start() throws Exception {
        this.server.start();
    }

    public Server getServer() {
        return this.server.getServer();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    private Map<String, String> getJerseyInitParams() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("javax.ws.rs.Application", EMIRAnonymousApplication.class.getCanonicalName());
        map.put("com.sun.jersey.spi.container.ContainerRequestFilters", this.getRequestFilters());
        map.put("com.sun.jersey.spi.container.ContainerResponseFilters", this.getResponseFilters());
        return map;
    }

    private String getResponseFilters() {
        StringBuilder sb = new StringBuilder();
        String s = this.serverProps.getValue("interceptors.response");
        sb.append(GZIPContentEncodingFilter.class.getName());
        if (s != null) {
            sb.append(";").append(s);
        }
        return sb.toString();
    }

    private String getRequestFilters() {
        StringBuilder sb = new StringBuilder();
        String s = this.serverProps.getValue("interceptors.request");
        sb.append(GZIPContentEncodingFilter.class.getName());
        if (s != null) {
            sb.append(";").append(s);
        }
        return sb.toString();
    }
}

