/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.infrastructure;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.EMIRClient;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.event.Event;
import eu.emi.emir.event.EventDispatcher;
import eu.emi.emir.event.EventListener;
import eu.emi.emir.infrastructure.EmptyIdentifierFailureException;
import eu.emi.emir.infrastructure.Filters;
import eu.emi.emir.infrastructure.InfrastructureManager;
import eu.emi.emir.infrastructure.Method;
import eu.emi.emir.infrastructure.NullPointerFailureException;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import javax.ws.rs.core.MediaType;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ServiceEventReceiver
implements EventListener,
Runnable {
    private static Logger logger = Log.getLogger((String)"emir.core", ServiceEventReceiver.class);
    private final WebResource client;
    private static InfrastructureManager infrastructure;
    private static boolean parent_lost;
    private Filters filter;

    public ServiceEventReceiver(String parentUrl) {
        infrastructure = new InfrastructureManager();
        try {
            infrastructure.setParent(parentUrl);
        }
        catch (EmptyIdentifierFailureException e) {
            logger.error((Object)"Empty parent URL added!");
        }
        catch (NullPointerFailureException e) {
            logger.error((Object)"NULL point error by the parent URL!");
        }
        EMIRClient c = new EMIRClient(parentUrl + "/serviceadmin");
        if (EMIRServer.getServerSecurityProperties().isSslEnabled()) {
            c = new EMIRClient(parentUrl + "/serviceadmin", (IClientConfiguration)EMIRServer.getClientSecurityProperties());
        }
        this.client = c.getClientResource();
        parent_lost = false;
        this.filter = new Filters();
    }

    @Override
    public void recieve(Event event) {
        int i;
        JSONArray errors;
        JSONArray jos;
        ArrayList<String> IDs;
        block38: {
            block37: {
                IDs = new ArrayList<String>();
                jos = new JSONArray();
                try {
                    jos = this.filter.outputFilter((JSONArray)event.getData());
                }
                catch (ClassCastException e) {
                    if (!logger.isDebugEnabled()) break block37;
                    logger.debug((Object)"event.data to JSONArray cast problem. May be delete message.");
                }
            }
            try {
                for (int i2 = 0; i2 < jos.length(); ++i2) {
                    IDs.add(jos.getJSONObject(i2).getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName()));
                }
            }
            catch (JSONException e1) {
                if (!logger.isDebugEnabled()) break block38;
                logger.debug((Object)e1);
            }
        }
        if (event.getType().equalsIgnoreCase("service_add")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"service added event fired");
            }
            try {
                ClientResponse res = (ClientResponse)this.client.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(ClientResponse.class, (Object)jos);
                if (res.getStatus() == ClientResponse.Status.OK.getStatusCode() || res.getStatus() == ClientResponse.Status.CONFLICT.getStatusCode()) {
                    if (parent_lost) {
                        if (res.getStatus() == ClientResponse.Status.CONFLICT.getStatusCode()) {
                            errors = (JSONArray)res.getEntity(JSONArray.class);
                            for (i = 0; i < errors.length(); ++i) {
                                try {
                                    IDs.remove(errors.getJSONObject(i).getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName()));
                                    continue;
                                }
                                catch (JSONException e) {
                                    Log.logException((String)"", (Throwable)e);
                                }
                            }
                        }
                        parent_lost = !infrastructure.dbSynchronization(IDs, Method.REGISTER, res.getStatus());
                    }
                } else if (res.getStatus() == ClientResponse.Status.UNAUTHORIZED.getStatusCode()) {
                    logger.debug((Object)"Does not have access for the parent.");
                }
            }
            catch (ClientHandlerException e) {
                parent_lost = true;
                infrastructure.handleRegistration(IDs);
            }
        }
        if (event.getType().equalsIgnoreCase("service_update")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"service update event fired");
            }
            try {
                ClientResponse res = (ClientResponse)this.client.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(ClientResponse.class, (Object)jos);
                if (res.getStatus() == ClientResponse.Status.OK.getStatusCode() || res.getStatus() == ClientResponse.Status.CONFLICT.getStatusCode()) {
                    if (parent_lost) {
                        if (res.getStatus() == ClientResponse.Status.CONFLICT.getStatusCode()) {
                            errors = (JSONArray)res.getEntity(JSONArray.class);
                            for (i = 0; i < errors.length(); ++i) {
                                IDs.remove(errors.getJSONObject(i).getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName()));
                            }
                        }
                        parent_lost = !infrastructure.dbSynchronization(IDs, Method.UPDATE, res.getStatus());
                    }
                } else if (res.getStatus() == ClientResponse.Status.UNAUTHORIZED.getStatusCode()) {
                    logger.debug((Object)"Does not have access for the parent.");
                }
            }
            catch (ClientHandlerException e) {
                parent_lost = true;
                infrastructure.handleUpdate(IDs);
            }
            catch (Exception e) {
                Log.logException((String)"Error making update on the parent dsr", (Throwable)e);
            }
        }
        if (event.getType().equalsIgnoreCase("service_delete")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"service added delete event fired");
            }
            String deleteSEID = null;
            try {
                deleteSEID = ((JSONObject)event.getData()).getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName());
                ClientResponse res = (ClientResponse)this.client.queryParam(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), deleteSEID).delete(ClientResponse.class);
                if (res.getStatus() == ClientResponse.Status.OK.getStatusCode()) {
                    if (parent_lost) {
                        ArrayList<String> ID = new ArrayList<String>();
                        ID.add(deleteSEID);
                        parent_lost = !infrastructure.dbSynchronization(ID, Method.DELETE, res.getStatus());
                    }
                } else if (res.getStatus() == ClientResponse.Status.UNAUTHORIZED.getStatusCode()) {
                    logger.debug((Object)"Does not have access for the parent.");
                }
            }
            catch (ClientHandlerException e) {
                parent_lost = true;
                infrastructure.handleDelete(deleteSEID);
            }
            catch (JSONException e) {
                logger.warn((Object)e.getCause());
            }
        }
    }

    @Override
    public void run() {
        EventDispatcher.add(this);
    }
}

