/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.infrastructure;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import eu.emi.emir.EMIRServer;
import eu.emi.emir.ServerProperties;
import eu.emi.emir.client.EMIRClient;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.db.MultipleResourceException;
import eu.emi.emir.db.NonExistingResourceException;
import eu.emi.emir.db.PersistentStoreFailureException;
import eu.emi.emir.db.mongodb.MongoDBServiceDatabase;
import eu.emi.emir.db.mongodb.ServiceObject;
import eu.emi.emir.infrastructure.EmptyIdentifierFailureException;
import eu.emi.emir.infrastructure.Method;
import eu.emi.emir.infrastructure.NullPointerFailureException;
import eu.emi.emir.infrastructure.ServiceInfrastructure;
import eu.emi.emir.security.ClientSecurityProperties;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;

public class InfrastructureManager
implements ServiceInfrastructure {
    private static Logger logger = Log.getLogger((String)"emir.core", InfrastructureManager.class);
    private static Connection conn;
    private static Statement stat;
    private String dbname = "emiregistry";
    private List<String> parentsRoute = new ArrayList<String>();

    public InfrastructureManager() {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            Log.logException((String)"", (Throwable)e);
        }
        try {
            String h2db = EMIRServer.getServerProperties().getValue(ServerProperties.PROP_H2_DBFILE_PATH);
            if (h2db == null || h2db.isEmpty()) {
                h2db = "/var/lib/emi/emir/data/Emiregistry";
            }
            conn = DriverManager.getConnection("jdbc:h2:" + h2db, "sa", "");
            stat = conn.createStatement();
            stat.execute("create table " + this.dbname + "(id varchar(255) primary key, new int, del int)");
        }
        catch (SQLException e) {
            if (e.toString().substring(30, 60).equals("Database may be already in use")) {
                logger.error((Object)("DB locked! " + e));
            }
            if (e.toString().substring(30, 64).equals("Table \"EMIREGISTRY\" already exists")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("DB exist. " + e));
                }
            }
            logger.error((Object)("Other SQL exception: " + e));
        }
    }

    protected void finalize() throws SQLException {
        stat.close();
        conn.close();
    }

    @Override
    public void setParentsRoute(List<String> identifiers) throws EmptyIdentifierFailureException, NullPointerFailureException {
        if (identifiers == null) {
            throw new NullPointerFailureException();
        }
        if (identifiers.isEmpty()) {
            throw new EmptyIdentifierFailureException();
        }
        this.parentsRoute.clear();
        this.parentsRoute.addAll(identifiers);
    }

    @Override
    public List<String> getParentsRoute() {
        return this.parentsRoute;
    }

    @Override
    public List<String> getChildDSRs() {
        ArrayList<String> result = new ArrayList<String>();
        logger.debug((Object)"Not implemented yet.");
        return result;
    }

    @Override
    public void addChildDSR(String identifier) throws EmptyIdentifierFailureException, NullPointerFailureException {
        if (identifier == null) {
            throw new NullPointerFailureException();
        }
        if (identifier.isEmpty()) {
            throw new EmptyIdentifierFailureException();
        }
        logger.debug((Object)"Not implemented yet.");
    }

    @Override
    public void setParent(String identifier) throws EmptyIdentifierFailureException, NullPointerFailureException {
        if (identifier == null) {
            throw new NullPointerFailureException();
        }
        if (identifier.isEmpty()) {
            throw new EmptyIdentifierFailureException();
        }
        this.parentsRoute.clear();
        this.parentsRoute.add(identifier);
    }

    @Override
    public String getParent() {
        if (this.parentsRoute.isEmpty()) {
            return "";
        }
        return this.parentsRoute.get(0);
    }

    public void handleRegistration(List<String> identifiers) {
        logger.debug((Object)"handleRegistration called...");
        for (int i = 0; i < identifiers.size(); ++i) {
            String identifier = identifiers.get(i);
            logger.debug((Object)("next ID by the Registration: " + identifier));
            try {
                ResultSet rs = stat.executeQuery("select * from " + this.dbname + " where id = '" + identifier + "'");
                if (!rs.first()) {
                    logger.debug((Object)(identifier + " is not in the list! Insert new record..."));
                    stat.execute("insert into " + this.dbname + " values('" + identifier + "', 1, 0)");
                    continue;
                }
                logger.debug((Object)("The list contains this '" + identifier + "' ID! Update comming..."));
                stat.execute("update " + this.dbname + " set del=0 where id='" + identifier + "'");
                continue;
            }
            catch (SQLException e) {
                Log.logException((String)"", (Throwable)e);
            }
        }
    }

    public void handleUpdate(List<String> identifiers) {
        logger.debug((Object)"handleUpdate called...");
        for (int i = 0; i < identifiers.size(); ++i) {
            String identifier = identifiers.get(i);
            logger.debug((Object)("next ID by the Update: " + identifier));
            try {
                ResultSet rs = stat.executeQuery("select * from " + this.dbname + " where id = '" + identifier + "'");
                if (!rs.first()) {
                    logger.debug((Object)(identifier + " is not in the list! Insert new record..."));
                    stat.execute("insert into " + this.dbname + " values('" + identifier + "', 0, 0)");
                    continue;
                }
                logger.debug((Object)("The list contains this '" + identifier + "' ID! Everything correct."));
                continue;
            }
            catch (SQLException e) {
                Log.logException((String)"", (Throwable)e);
            }
        }
    }

    public void handleDelete(String identifier) {
        logger.debug((Object)("handleDelete called with this ID: " + identifier));
        try {
            ResultSet rs = stat.executeQuery("select * from " + this.dbname + " where id = '" + identifier + "'");
            if (!rs.first()) {
                logger.debug((Object)(identifier + " is not in the list! Insert new record..."));
                stat.execute("insert into " + this.dbname + " values('" + identifier + "', 0, 1)");
            } else {
                logger.debug((Object)("The list contains this '" + identifier + "' ID!"));
                if (rs.getString(2).equals("1")) {
                    logger.debug((Object)("Remove this '" + identifier + "' ID from the list!"));
                    stat.execute("delete from " + this.dbname + " where id='" + identifier + "'");
                } else {
                    logger.debug((Object)"Update comming...");
                    stat.execute("update " + this.dbname + " set del=1 where id='" + identifier + "'");
                }
            }
        }
        catch (SQLException e) {
            Log.logException((String)"", (Throwable)e);
        }
    }

    public boolean dbSynchronization(List<String> ids, Method method, int responsestatus) {
        logger.debug((Object)"DB synchronization started.");
        block19: for (int i = 0; i < ids.size(); ++i) {
            String id = ids.get(i);
            switch (method) {
                case REGISTER: {
                    logger.debug((Object)("REGISTRATION comming..., ID: " + id + ", response status: " + responsestatus));
                    if (responsestatus == ClientResponse.Status.OK.getStatusCode()) {
                        try {
                            logger.debug((Object)"register, delete");
                            stat.execute("delete from " + this.dbname + " where id='" + id + "'");
                        }
                        catch (SQLException e) {}
                        continue block19;
                    }
                    if (responsestatus != ClientResponse.Status.CONFLICT.getStatusCode()) continue block19;
                    try {
                        logger.debug((Object)"register, update");
                        stat.execute("update " + this.dbname + " set new=0, del=0 where id='" + id + "'");
                    }
                    catch (SQLException e) {}
                    continue block19;
                }
                case UPDATE: {
                    logger.debug((Object)("UPDATE comming..., ID: " + id + ", response status: " + responsestatus));
                    if (responsestatus == ClientResponse.Status.OK.getStatusCode()) {
                        try {
                            stat.execute("delete from " + this.dbname + " where id='" + id + "'");
                        }
                        catch (SQLException e) {}
                        continue block19;
                    }
                    if (responsestatus != ClientResponse.Status.CONFLICT.getStatusCode()) continue block19;
                    try {
                        stat.execute("update " + this.dbname + " set new=1, del=0 where id='" + id + "'");
                    }
                    catch (SQLException e) {}
                    continue block19;
                }
                case DELETE: {
                    logger.debug((Object)("DELETE comming..., ID: " + id + ", response status: " + responsestatus));
                    if (responsestatus != ClientResponse.Status.OK.getStatusCode()) continue block19;
                    try {
                        stat.execute("delete from " + this.dbname + " where id='" + id + "'");
                    }
                    catch (SQLException e) {}
                    continue block19;
                }
                default: {
                    logger.debug((Object)("Bad method type, ID: " + id));
                    return false;
                }
            }
        }
        int maxMessageSize = EMIRServer.getServerProperties().getIntValue("record.maximum");
        boolean register = true;
        JSONArray jos = this.search(1, 0);
        if (jos.length() > 0) {
            for (int i = 0; i < jos.length(); i += maxMessageSize) {
                JSONArray sended = new JSONArray();
                for (int index = i; index < i + maxMessageSize && index < jos.length(); ++index) {
                    try {
                        sended.put((Object)jos.getJSONObject(index));
                        continue;
                    }
                    catch (JSONException e) {
                        Log.logException((String)"", (Throwable)e);
                    }
                }
                register = register && this.send(sended, Method.REGISTER);
            }
        }
        boolean update = true;
        jos = this.search(0, 0);
        if (jos.length() > 0) {
            for (int i = 0; i < jos.length(); i += maxMessageSize) {
                JSONArray sended = new JSONArray();
                for (int index = i; index < i + maxMessageSize && index < jos.length(); ++index) {
                    try {
                        sended.put((Object)jos.getJSONObject(index));
                        continue;
                    }
                    catch (JSONException e) {
                        Log.logException((String)"", (Throwable)e);
                    }
                }
                update = update && this.send(sended, Method.UPDATE);
            }
        }
        boolean delete = true;
        jos = this.search(0, 1);
        if (jos.length() > 0) {
            delete = this.send(jos, Method.DELETE);
        }
        return register && update && delete;
    }

    private JSONArray search(int ne, int del) {
        JSONArray jo = new JSONArray();
        ArrayList<String> ids = new ArrayList<String>();
        logger.debug((Object)("search new = " + ne + " del= " + del));
        try {
            ResultSet rs = stat.executeQuery("select id from " + this.dbname + " where new = " + ne + " and del = " + del + "");
            while (rs.next()) {
                ids.add(rs.getString("id"));
                if (ne != 0 || del != 1) continue;
                jo.put((Object)rs.getString("id"));
            }
        }
        catch (SQLException e) {
            Log.logException((String)"", (Throwable)e);
        }
        if (ne == 0 && del == 1) {
            return jo;
        }
        ServerProperties sp = EMIRServer.getServerProperties();
        MongoDBServiceDatabase mongoDB = new MongoDBServiceDatabase(sp.getValue("mongodb.hostName"), sp.getIntValue("mongodb.port"), sp.getValue("mongodb.dbName"), sp.getValue("mongodb.collectionName"));
        ServiceObject so = null;
        try {
            for (int i = 0; i < ids.size(); ++i) {
                so = mongoDB.getServiceByUrl((String)ids.get(i));
                if (so == null) continue;
                System.out.println("Stored JSON: " + so.toJSON().toString());
                jo.put((Object)so.toJSON());
            }
        }
        catch (MultipleResourceException e) {
            Log.logException((String)"", (Throwable)e);
        }
        catch (PersistentStoreFailureException e) {
            Log.logException((String)"", (Throwable)e);
        }
        catch (NonExistingResourceException e) {
            Log.logException((String)"", (Throwable)e);
        }
        return jo;
    }

    private boolean send(JSONArray jos, Method method) {
        ServerProperties sp = EMIRServer.getServerProperties();
        String parentUrl = sp.getValue("parentAddress");
        EMIRClient c = null;
        if (parentUrl.startsWith("https")) {
            ClientSecurityProperties csp = null;
            try {
                csp = EMIRServer.getClientSecurityProperties();
            }
            catch (Exception e) {
                Log.logException((String)"Error reading the security properties", (Throwable)e);
            }
            c = new EMIRClient(parentUrl + "/serviceadmin", (IClientConfiguration)csp);
        } else {
            c = new EMIRClient(parentUrl + "/serviceadmin");
        }
        WebResource client = c.getClientResource();
        ClientResponse res = null;
        boolean retval = true;
        int cycleNr = 1;
        if (method == Method.DELETE) {
            cycleNr = jos.length();
        }
        for (int i = 0; i < cycleNr; ++i) {
            try {
                switch (method) {
                    case REGISTER: {
                        logger.debug((Object)"send register");
                        res = (ClientResponse)client.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(ClientResponse.class, (Object)jos);
                        break;
                    }
                    case UPDATE: {
                        logger.debug((Object)"send update");
                        res = (ClientResponse)client.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(ClientResponse.class, (Object)jos);
                        break;
                    }
                    case DELETE: {
                        logger.debug((Object)"send delete");
                        res = (ClientResponse)client.queryParam(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), jos.getString(i)).delete(ClientResponse.class);
                        break;
                    }
                }
            }
            catch (ClientHandlerException e) {
                retval = false;
            }
            catch (UniformInterfaceException e) {
                Log.logException((String)"", (Throwable)e);
                retval = false;
            }
            catch (JSONException e) {
                Log.logException((String)"", (Throwable)e);
                retval = false;
            }
            if (res.getStatus() == ClientResponse.Status.OK.getStatusCode()) {
                try {
                    if (method == Method.DELETE) {
                        this.deleteentry(jos.getString(i));
                    } else if (method == Method.REGISTER) {
                        this.databaseclean(1, 0);
                    } else if (method == Method.UPDATE) {
                        this.databaseclean(0, 0);
                    }
                }
                catch (JSONException e) {
                    Log.logException((String)"", (Throwable)e);
                }
            }
            if (res.getStatus() != ClientResponse.Status.CONFLICT.getStatusCode()) continue;
            int failedIndex = 0;
            String failedSEID = "";
            JSONArray failedJSONs = (JSONArray)res.getEntity(JSONArray.class);
            try {
                failedSEID = failedJSONs.getJSONObject(failedIndex).get(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName()).toString();
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
            String currentSEID = "";
            for (int j = 0; j != jos.length(); ++j) {
                try {
                    currentSEID = jos.getJSONObject(j).get(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName()).toString();
                }
                catch (JSONException e) {
                    Log.logException((String)"", (Throwable)e);
                    break;
                }
                if (!currentSEID.equals(failedSEID)) {
                    this.deleteentry(currentSEID);
                    continue;
                }
                if (++failedIndex >= failedJSONs.length()) continue;
                try {
                    failedSEID = failedJSONs.getJSONObject(failedIndex).get(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName()).toString();
                    continue;
                }
                catch (JSONException e) {
                    Log.logException((String)"", (Throwable)e);
                }
            }
            logger.debug((Object)("Error during the " + method.name() + " method."));
            retval = false;
        }
        return retval;
    }

    private void databaseclean(int ne, int del) {
        logger.debug((Object)("Database cleaning! new=" + ne + " del=" + del));
        try {
            stat.execute("delete from " + this.dbname + " where new=" + ne + " and del=" + del);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void deleteentry(String id) {
        logger.debug((Object)("Delete entry! id=" + id));
        try {
            stat.execute("delete from " + this.dbname + " where id='" + id + "'");
        }
        catch (SQLException e) {
            Log.logException((String)"", (Throwable)e);
        }
    }
}

