/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.infrastructure;

import com.sun.jersey.api.client.ClientResponse;
import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.EMIRClient;
import eu.emi.emir.infrastructure.EmptyIdentifierFailureException;
import eu.emi.emir.infrastructure.NullPointerFailureException;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChildrenManager {
    private static ChildrenManager instance = null;
    private Map<String, Date> childServices = new HashMap<String, Date>();
    private long hour = 3720000L;

    public static synchronized ChildrenManager getInstance() {
        if (instance == null) {
            instance = new ChildrenManager();
        }
        return instance;
    }

    public synchronized List<String> getChildDSRs() {
        ArrayList<String> result = new ArrayList<String>();
        Date currentTime = new Date();
        Set<String> s = this.childServices.keySet();
        for (String key : s) {
            Date value = this.childServices.get(key);
            if (value.getTime() + this.hour > currentTime.getTime()) {
                result.add(key);
                continue;
            }
            this.childServices.remove(key);
        }
        return result;
    }

    public synchronized boolean addChildDSR(String identifier) throws EmptyIdentifierFailureException, NullPointerFailureException {
        if (identifier == null) {
            throw new NullPointerFailureException();
        }
        if (identifier.isEmpty()) {
            throw new EmptyIdentifierFailureException();
        }
        boolean retval = false;
        if (this.childServices.containsKey(identifier)) {
            Date currentTime = new Date();
            Date value = this.childServices.get(identifier);
            if (value.getTime() + this.hour <= currentTime.getTime()) {
                retval = true;
            }
            this.childServices.remove(identifier);
        } else {
            retval = true;
        }
        this.childServices.put(identifier, new Date());
        return retval;
    }

    public synchronized void childLiveCheck() {
        Set<String> s = this.childServices.keySet();
        for (String key : s) {
            ClientResponse res;
            EMIRClient c = new EMIRClient(key + "/ping");
            if (EMIRServer.getServerSecurityProperties().isSslEnabled()) {
                c = new EMIRClient(key + "/ping", (IClientConfiguration)EMIRServer.getClientSecurityProperties());
            }
            if ((res = (ClientResponse)c.getClientResource().accept(new String[]{"text/plain"}).get(ClientResponse.class)).getStatus() == ClientResponse.Status.OK.getStatusCode()) continue;
            this.childServices.remove(key);
        }
    }
}

