/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.db.mongodb;

import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.DateUtil;
import eu.emi.emir.client.util.Log;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ServiceObject {
    private static Logger logger = Log.getLogger((String)"emir.core", ServiceObject.class);
    private static final long serialVersionUID = -8819684158264382427L;
    private final JSONObject jo;

    public ServiceObject(String jsonString) throws JSONException {
        this.jo = new JSONObject(jsonString);
    }

    public ServiceObject(JSONObject jo) throws JSONException {
        this.jo = jo;
    }

    public ServiceObject(DBObject jo) throws JSONException {
        this.jo = new JSONObject(JSON.serialize((Object)jo));
    }

    public String getServiceOwner() {
        String owner = null;
        try {
            owner = this.jo.get(ServiceBasicAttributeNames.SERVICE_OWNER_DN.getAttributeName()).toString();
        }
        catch (JSONException e) {
            Log.logException((String)"serviceOwner not exist!", (Throwable)e);
        }
        return owner;
    }

    public String getUrl() {
        String serviceUrl = null;
        try {
            serviceUrl = this.jo.get(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName()).toString();
        }
        catch (JSONException e) {
            Log.logException((String)"", (Throwable)e);
        }
        return serviceUrl;
    }

    public String getEndpointID() {
        String serviceEndpointID = null;
        try {
            serviceEndpointID = this.jo.get(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName()).toString();
        }
        catch (JSONException e) {
            Log.logException((String)"", (Throwable)e);
        }
        return serviceEndpointID;
    }

    public String getServiceID() {
        String serviceID = null;
        try {
            serviceID = this.jo.get(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName()).toString();
        }
        catch (JSONException e) {
            Log.logException((String)"", (Throwable)e);
        }
        return serviceID;
    }

    public Date getCreationTime() {
        Date d = null;
        try {
            d = DateUtil.ServiceDateFormat.parse((String)this.jo.get(ServiceBasicAttributeNames.SERVICE_CREATED_ON.getAttributeName()));
        }
        catch (ParseException e) {
            Log.logException((String)"", (Throwable)e, (Logger)logger);
        }
        catch (JSONException e) {
            Log.logException((String)"", (Throwable)e);
        }
        return d;
    }

    public Date getUpdateSince() {
        Date d = null;
        try {
            d = DateUtil.UTCISODateFormat.parse(((JSONObject)this.jo.get(ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName())).get("$date").toString());
        }
        catch (ParseException e) {
            Log.logException((String)"", (Throwable)e, (Logger)logger);
        }
        catch (JSONException e) {
            Log.logException((String)"", (Throwable)e);
        }
        catch (ClassCastException e) {
            Log.logException((String)"No updateSince attribute by the \"deleted\" entry!", (Throwable)e);
            d = new Date(1L);
        }
        return d;
    }

    public Date getExpireOn() {
        Date d = null;
        try {
            d = DateUtil.ServiceDateFormat.parse((String)this.jo.get(ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.getAttributeName()));
        }
        catch (ParseException e) {
            Log.logException((String)"", (Throwable)e, (Logger)logger);
        }
        catch (JSONException e) {
            Log.logException((String)"", (Throwable)e);
        }
        return d;
    }

    public JSONObject toJSON() {
        if (this.jo == null) {
            return null;
        }
        return this.jo;
    }

    public DBObject toDBObject() {
        DBObject d = null;
        d = (DBObject)JSON.parse((String)this.toString());
        return d;
    }

    public String toString() {
        return this.jo.toString();
    }
}

