/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.db.mongodb;

import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.util.JSON;
import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.db.ExistingResourceException;
import eu.emi.emir.db.MultipleResourceException;
import eu.emi.emir.db.NonExistingResourceException;
import eu.emi.emir.db.PersistentStoreFailureException;
import eu.emi.emir.db.QueryException;
import eu.emi.emir.db.ServiceDatabase;
import eu.emi.emir.db.mongodb.ServiceObject;
import eu.emi.emir.event.Event;
import eu.emi.emir.event.EventDispatcher;
import eu.emi.emir.validator.InvalidServiceDescriptionException;
import eu.emi.emir.validator.RegistrationValidator;
import eu.unicore.util.configuration.ConfigurationException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.bson.BSONObject;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.util.VersionUtil;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class MongoDBServiceDatabase
implements ServiceDatabase {
    private static Logger logger = Log.getLogger((String)"emir.db", MongoDBServiceDatabase.class);
    private static MongoClient connection;
    private DB database;
    private DBCollection serviceCollection;
    private String hostName;
    private Integer port;
    private String colName;
    private String dbName;
    private String userName;
    private String password;
    private static String dbVersion;

    public MongoDBServiceDatabase() {
        if (EMIRServer.getServerProperties() == null) {
            new EMIRServer();
        }
        this.hostName = EMIRServer.getServerProperties().getValue("mongodb.hostName");
        this.port = EMIRServer.getServerProperties().getIntValue("mongodb.port");
        this.dbName = EMIRServer.getServerProperties().getValue("mongodb.dbName");
        this.colName = EMIRServer.getServerProperties().getValue("mongodb.collectionName");
        this.userName = EMIRServer.getServerProperties().getValue("mongodb.userName");
        this.password = EMIRServer.getServerProperties().getValue("mongodb.password");
        try {
            BasicDBObject nonUniqueIndexKeys;
            BasicDBObject obj;
            if (connection == null) {
                MongoClientOptions mo = MongoClientOptions.builder().autoConnectRetry(true).connectTimeout(5000).maxAutoConnectRetryTime(10000L).maxWaitTime(5000).socketKeepAlive(true).socketTimeout(0).connectionsPerHost(255).build();
                ServerAddress sa = new ServerAddress(this.hostName, Integer.valueOf(this.port).intValue());
                connection = new MongoClient(sa, mo);
            }
            this.database = connection.getDB(this.dbName);
            if (!(this.userName == null || this.userName.equalsIgnoreCase("") || this.password.equalsIgnoreCase("") || this.database.authenticate(this.userName, this.password.toCharArray()))) {
                Log.logException((String)("Cannot authenticate the user: " + this.userName + "\nProvide the correct MongoDB database username and password in configuration file and restart the EMIR server again"), (Throwable)new RuntimeException("MongoDB Authentication Failed"));
                System.out.printf("%s:%s.%s.%s", "Error occurred while starting the EMIR server", "Cannot authenticate the database User: " + this.userName, " Provide the correct MongoDB database username and password in configuration file and restart the EMIR server again", " Stoppoing the EMIR server.");
                System.exit(1);
            }
            this.serviceCollection = this.database.getCollection(this.colName);
            if (this.isVersionNumber241OrGreater()) {
                obj = new BasicDBObject(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)1);
                this.serviceCollection.ensureIndex((DBObject)obj, ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), true);
                nonUniqueIndexKeys = new BasicDBObject();
                nonUniqueIndexKeys.put(ServiceBasicAttributeNames.SERVICE_NAME.getAttributeName(), (Object)1);
                nonUniqueIndexKeys.put(ServiceBasicAttributeNames.SERVICE_TYPE.getAttributeName(), (Object)1);
                nonUniqueIndexKeys.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_CAPABILITY.getAttributeName(), (Object)1);
                this.serviceCollection.ensureIndex((DBObject)nonUniqueIndexKeys, "secondary", false);
            } else {
                obj = new BasicDBObject(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)"1");
                this.serviceCollection.ensureIndex((DBObject)obj, ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), true);
                nonUniqueIndexKeys = new BasicDBObject();
                nonUniqueIndexKeys.put(ServiceBasicAttributeNames.SERVICE_NAME.getAttributeName(), (Object)"1");
                nonUniqueIndexKeys.put(ServiceBasicAttributeNames.SERVICE_TYPE.getAttributeName(), (Object)"1");
                nonUniqueIndexKeys.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_CAPABILITY.getAttributeName(), (Object)"1");
                this.serviceCollection.ensureIndex((DBObject)nonUniqueIndexKeys, "secondary", false);
            }
        }
        catch (MongoException e) {
            Log.logException((String)"", (Throwable)e, (Logger)logger);
            logger.warn((Object)e.getCause());
        }
        catch (Exception e) {
            logger.error((Object)"Error in connecting the MongoDB database", (Throwable)e);
        }
    }

    public MongoDBServiceDatabase(String hostname, Integer port, String dbName, String colName) {
        try {
            this.hostName = hostname;
            this.dbName = dbName;
            this.colName = colName;
            this.port = port;
            this.init();
        }
        catch (Exception e) {
            logger.error((Object)"Error in connecting the MongoDB database", (Throwable)e);
        }
    }

    private void init() {
        try {
            if (connection == null) {
                connection = new MongoClient(this.hostName, this.port.intValue());
            }
            this.database = connection.getDB(this.dbName);
            this.serviceCollection = this.database.getCollection(this.colName);
            BasicDBObject obj = this.getUniqueIndexes();
            this.serviceCollection.ensureIndex((DBObject)this.getUniqueIndexes(), ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), true);
            this.serviceCollection.ensureIndex((DBObject)this.getNonUniqueIndexes());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unique index created: " + obj));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in connecting the MongoDB database", (Throwable)e);
        }
    }

    private BasicDBObject getUniqueIndexes() {
        BasicDBObject obj = new BasicDBObject(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)1);
        return obj;
    }

    private BasicDBObject getNonUniqueIndexes() {
        BasicDBObject nonUniqueIndexKeys = new BasicDBObject();
        nonUniqueIndexKeys.put(ServiceBasicAttributeNames.SERVICE_NAME.getAttributeName(), (Object)1);
        nonUniqueIndexKeys.put(ServiceBasicAttributeNames.SERVICE_TYPE.getAttributeName(), (Object)1);
        nonUniqueIndexKeys.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_CAPABILITY.getAttributeName(), (Object)1);
        return nonUniqueIndexKeys;
    }

    @Override
    public void insert(ServiceObject item) throws ExistingResourceException, PersistentStoreFailureException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("inserting: " + item.toDBObject()));
            }
            this.database.requestStart();
            this.database.requestEnsureConnection();
            DBObject db = item.toDBObject();
            this.serviceCollection.insert(db, WriteConcern.SAFE);
            this.database.requestDone();
            logger.info((Object)("inserted Service Endpoint record with ID: " + item.getEndpointID()));
        }
        catch (MongoException e) {
            if (e instanceof MongoException.DuplicateKey) {
                throw new ExistingResourceException("Endpoint record with ID: " + item.getEndpointID() + " - already exists", e);
            }
            throw new PersistentStoreFailureException(e);
        }
    }

    @Override
    public ServiceObject getServiceByUrl(String identifier) throws MultipleResourceException, NonExistingResourceException, PersistentStoreFailureException {
        ServiceObject so = null;
        try {
            DBObject db = this.serviceCollection.findOne((DBObject)new BasicDBObject(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName(), (Object)identifier));
            if (db == null) {
                return null;
            }
            so = new ServiceObject(db);
        }
        catch (MongoException e) {
            Log.logException((String)"", (Throwable)e);
        }
        catch (JSONException e) {
            throw new NonExistingResourceException(e);
        }
        return so;
    }

    @Override
    public ServiceObject getServiceByEndpointID(String identifier) throws MultipleResourceException, NonExistingResourceException, PersistentStoreFailureException {
        ServiceObject so = null;
        try {
            System.out.println(this.findAll());
            DBObject db = this.serviceCollection.findOne((DBObject)new BasicDBObject(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)identifier));
            if (db == null) {
                return null;
            }
            so = new ServiceObject(db);
        }
        catch (MongoException e) {
            Log.logException((String)"", (Throwable)e);
        }
        catch (JSONException e) {
            throw new NonExistingResourceException(e);
        }
        return so;
    }

    @Override
    public void deleteByEndpointID(String endpointID) throws MultipleResourceException, NonExistingResourceException, PersistentStoreFailureException {
        this.database.requestStart();
        this.database.requestEnsureConnection();
        BasicDBObject query = new BasicDBObject();
        query.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)endpointID);
        DBObject d = this.serviceCollection.findAndRemove((DBObject)query);
        this.database.requestDone();
        if (d == null) {
            if (logger.isDebugEnabled()) {
                String msg = "No service description with the Endpoint ID:" + endpointID + " exists";
                logger.debug((Object)msg);
            }
            throw new NonExistingResourceException("No service description with the Endpoint ID:" + endpointID + " exists");
        }
        logger.info((Object)("DELETED Service Endpoint Record with ID: " + endpointID));
        try {
            JSONObject deletedEntry = new JSONObject(d.toString());
            EventDispatcher.notifyRecievers(new Event("service_delete", deletedEntry));
        }
        catch (JSONException e) {
            logger.warn((Object)e.getCause());
        }
    }

    @Override
    public void update(ServiceObject sObj) throws MultipleResourceException, NonExistingResourceException, PersistentStoreFailureException {
        try {
            String id = sObj.getEndpointID();
            logger.debug((Object)("updating service description: " + sObj));
            this.database.requestStart();
            this.database.requestEnsureConnection();
            DBObject dbObj = sObj.toDBObject();
            BasicDBObject query = new BasicDBObject();
            query.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)sObj.getEndpointID());
            DBObject db = this.serviceCollection.findOne((DBObject)new BasicDBObject(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)sObj.getEndpointID()));
            if (db == null) {
                try {
                    new RegistrationValidator().validateInfo(sObj.toJSON());
                }
                catch (ConfigurationException e) {
                    Log.logException((String)("Error during the update message validation. (ID:" + id + ")"), (Throwable)e, (Logger)logger);
                    return;
                }
                catch (InvalidServiceDescriptionException e) {
                    Log.logException((String)("Error during the update message validation. (ID:" + id + ")"), (Throwable)e, (Logger)logger);
                    return;
                }
                catch (JSONException e) {
                    Log.logException((String)("Error during the update message validation. (ID:" + id + ")"), (Throwable)e, (Logger)logger);
                    return;
                }
                catch (ParseException e) {
                    Log.logException((String)("Error during the update message validation. (ID:" + id + ")"), (Throwable)e, (Logger)logger);
                    return;
                }
            }
            this.serviceCollection.update((DBObject)query, dbObj, true, false);
            this.database.requestDone();
            logger.info((Object)("CREATED/UPDATED Service Endpoint Record with ID: " + id));
        }
        catch (MongoException e) {
            Log.logException((String)("Error updating the Service Record in MongoDB: " + sObj), (Throwable)e, (Logger)logger);
        }
    }

    @Override
    public List<ServiceObject> query(String query) throws QueryException, PersistentStoreFailureException {
        DBObject o = (DBObject)JSON.parse((String)query);
        DBCursor cur = this.serviceCollection.find(o);
        CopyOnWriteArrayList<ServiceObject> resultCollection = new CopyOnWriteArrayList<ServiceObject>();
        try {
            while (cur.hasNext()) {
                ServiceObject s = new ServiceObject(cur.next().toString());
                resultCollection.add(s);
            }
            logger.debug((Object)JSON.serialize((Object)cur.explain()));
            cur.close();
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
        return Collections.unmodifiableList(resultCollection);
    }

    @Override
    public List<ServiceObject> query(String query, Integer limit, Integer skip) throws QueryException, PersistentStoreFailureException {
        DBObject o = (DBObject)JSON.parse((String)query);
        DBCursor cur = this.serviceCollection.find(o).skip(skip.intValue()).limit(limit.intValue());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("result size: " + cur.size()));
        }
        ArrayList<ServiceObject> resultCollection = new ArrayList<ServiceObject>();
        try {
            while (cur.hasNext()) {
                ServiceObject s = new ServiceObject(cur.next());
                resultCollection.add(s);
            }
            logger.debug((Object)JSON.serialize((Object)cur.explain()));
            cur.close();
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
        return Collections.unmodifiableList(resultCollection);
    }

    @Override
    public List<ServiceObject> query(String query, Integer skip) throws QueryException, PersistentStoreFailureException {
        DBObject o = (DBObject)JSON.parse((String)query);
        DBCursor cur = this.serviceCollection.find(o).skip(skip.intValue());
        logger.debug((Object)cur.getCursorId());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("result size: " + cur.size()));
        }
        ArrayList<ServiceObject> resultCollection = new ArrayList<ServiceObject>();
        try {
            while (cur.hasNext()) {
                ServiceObject s = new ServiceObject(cur.next().toString());
                resultCollection.add(s);
            }
            logger.debug((Object)JSON.serialize((Object)cur.explain()));
            cur.close();
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
        return Collections.unmodifiableList(resultCollection);
    }

    @Override
    public JSONArray queryJSON(String query) throws QueryException, PersistentStoreFailureException, MongoException, JSONException {
        DBObject o = (DBObject)JSON.parse((String)query);
        DBCursor cur = this.serviceCollection.find(o);
        JSONArray arr = new JSONArray();
        while (cur.hasNext()) {
            arr.put((Object)new JSONObject(JSON.serialize((Object)cur.next())));
        }
        logger.debug((Object)JSON.serialize((Object)cur.explain()));
        cur.close();
        return arr;
    }

    @Override
    public JSONArray queryJSON(String query, Integer limit, Integer skip) throws QueryException, PersistentStoreFailureException {
        DBObject o = (DBObject)JSON.parse((String)query);
        DBCursor cur = this.serviceCollection.find(o).skip(skip.intValue()).limit(limit.intValue());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("result size: " + cur.size()));
        }
        JSONArray arr = new JSONArray();
        try {
            while (cur.hasNext()) {
                arr.put((Object)new JSONObject(JSON.serialize((Object)cur.next())));
            }
            logger.debug((Object)JSON.serialize((Object)cur.explain()));
            cur.close();
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
        return arr;
    }

    @Override
    public JSONArray queryJSON(String query, Integer skip) throws QueryException, PersistentStoreFailureException {
        DBObject o = (DBObject)JSON.parse((String)query);
        DBCursor cur = this.serviceCollection.find(o).skip(skip.intValue());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("result size: " + cur.size()));
        }
        JSONArray arr = new JSONArray();
        try {
            while (cur.hasNext()) {
                arr.put((Object)new JSONObject(JSON.serialize((Object)cur.next())));
            }
            logger.debug((Object)JSON.serialize((Object)cur.explain()));
            cur.close();
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
        return arr;
    }

    @Override
    public JSONArray queryJSONWithLimit(String s, Integer limit) {
        DBObject o = (DBObject)JSON.parse((String)s);
        DBCursor cur = this.serviceCollection.find(o).limit(limit.intValue());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("result size: " + cur.size()));
        }
        JSONArray arr = new JSONArray();
        try {
            while (cur.hasNext()) {
                arr.put((Object)new JSONObject(JSON.serialize((Object)cur.next())));
            }
            logger.debug((Object)JSON.serialize((Object)cur.explain()));
            cur.close();
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
        return arr;
    }

    @Override
    public JSONArray queryDistinctJSON(String attributeName) {
        String s = "{ " + ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.getAttributeName() + " : { $exists : true } }";
        DBObject query = (DBObject)JSON.parse((String)s);
        List lst = this.serviceCollection.distinct(attributeName, query);
        JSONArray arr = new JSONArray((Collection)lst);
        return arr;
    }

    @Override
    public JSONArray paginatedQuery(String query, Integer pageSize, String id) {
        return this.paginatedQuery(query, pageSize, id, "_id");
    }

    @Override
    public JSONArray paginatedQuery(String query, Integer pageSize, String id, String orderBy) {
        DBObject queryObj = (DBObject)JSON.parse((String)query);
        DBCursor cur = null;
        if (orderBy == null || orderBy.isEmpty()) {
            orderBy = "_id";
        }
        BasicDBObject OrderBy = new BasicDBObject(orderBy, (Object)1);
        if (id == null) {
            cur = this.serviceCollection.find(queryObj).sort((DBObject)OrderBy).limit(pageSize.intValue());
        } else {
            StringBuffer b = new StringBuffer();
            b.append("{").append("\"_id\"").append(":").append("{").append("\"$gt\":").append("{").append("\"$oid\"").append(":\"").append(id).append("\"}").append("}}");
            DBObject db = (DBObject)JSON.parse((String)b.toString());
            if (queryObj.keySet().size() > 0) {
                db.putAll((BSONObject)queryObj);
            }
            cur = this.serviceCollection.find(db).sort((DBObject)OrderBy).limit(pageSize.intValue());
            logger.debug((Object)JSON.serialize((Object)cur.explain()));
        }
        JSONArray arr = new JSONArray();
        try {
            while (cur.hasNext()) {
                arr.put((Object)new JSONObject(JSON.serialize((Object)cur.next())));
            }
            logger.debug((Object)JSON.serialize((Object)cur.explain()));
            cur.close();
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
        return arr;
    }

    @Override
    public void deleteAll() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"deleting all the contents from the db collection");
        }
        BasicDBObject o = new BasicDBObject(0);
        this.database.requestStart();
        this.serviceCollection.remove((DBObject)o);
        this.database.requestDone();
        logger.info((Object)"deleted all the contents from the db collection");
    }

    @Override
    public List<ServiceObject> findAll() throws JSONException {
        CopyOnWriteArrayList<ServiceObject> lst = new CopyOnWriteArrayList<ServiceObject>();
        DBCursor c = this.serviceCollection.find();
        while (c.hasNext()) {
            DBObject type = c.next();
            ServiceObject s = new ServiceObject(type.toString());
            lst.add(s);
        }
        c.close();
        return Collections.unmodifiableList(lst);
    }

    @Override
    public void findAndDelete(String query) {
        DBObject db = (DBObject)JSON.parse((String)query);
        if (logger.isTraceEnabled()) {
            logger.debug((Object)("delete by query: " + db.toString()));
        }
        this.database.requestStart();
        this.database.requestEnsureConnection();
        this.serviceCollection.remove(db);
        this.database.requestDone();
    }

    public void dropCollection() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("dropping collection: " + this.serviceCollection.getName()));
        }
        this.serviceCollection.drop();
    }

    public void dropDB() {
        this.database.dropDatabase();
    }

    public void dropDB(String dbName) {
        connection.dropDatabase(dbName);
    }

    public DB createOrGetDB(String name) {
        return connection.getDB(name);
    }

    @Override
    public String getDBVersion() {
        if (dbVersion == null) {
            CommandResult result = this.database.command("serverStatus");
            dbVersion = result.getString("version");
        }
        return dbVersion;
    }

    @Override
    public Long size() {
        if (this.serviceCollection == null) {
            return 0L;
        }
        Long size = this.serviceCollection.count();
        return size;
    }

    @Override
    @Deprecated
    public JSONArray facetedQuery(Set<String> j) throws JSONException {
        JSONArray ja = new JSONArray();
        for (String str : j) {
            BasicDBObject match = new BasicDBObject();
            match.put("$match", (Object)new BasicDBObject());
            BasicDBObject fields = new BasicDBObject();
            BasicDBObject project = new BasicDBObject();
            BasicDBObject groupFields = new BasicDBObject();
            fields.put(str, (Object)1);
            project.put("$project", (Object)fields);
            groupFields.put("_id", (Object)("$" + str));
            groupFields.put("count", (Object)new BasicDBObject("$sum", (Object)1));
            BasicDBObject group = new BasicDBObject("$group", (Object)groupFields);
            AggregationOutput output = this.serviceCollection.aggregate((DBObject)match, new DBObject[]{project, group});
            Iterable it = output.results();
            JSONArray terms = new JSONArray();
            for (DBObject dbObject : it) {
                JSONObject term = new JSONObject(JSON.serialize((Object)dbObject));
                System.out.println(term);
                terms.put((Object)term);
            }
            System.out.println("\n\n");
            JSONObject attrName = new JSONObject();
            attrName.put(str, (Object)terms);
            ja.put((Object)attrName);
        }
        return ja;
    }

    @Override
    public JSONArray facetedQuery(Map<String, String> map) throws Exception {
        if (!this.isVersionNumber241OrGreater()) {
            UnsupportedOperationException u = new UnsupportedOperationException("The MongoDB server version should be equal to or greater than: 2.4.1, current version is: " + this.getDBVersion());
            Log.logException((String)("Faceted query is not supported in the current backend MongoDB, please update to the version: " + this.getDBVersion()), (Throwable)u);
            throw u;
        }
        JSONArray ja = new JSONArray();
        Set<String> j = map.keySet();
        for (String key : j) {
            BasicDBObject match = new BasicDBObject();
            match.put("$match", (Object)new BasicDBObject());
            BasicDBObject fields = new BasicDBObject();
            BasicDBObject project = new BasicDBObject();
            BasicDBObject groupFields = new BasicDBObject();
            BasicDBObject unwindFields = new BasicDBObject();
            fields.put(key, (Object)1);
            project.put("$project", (Object)fields);
            groupFields.put("_id", (Object)("$" + key));
            groupFields.put("count", (Object)new BasicDBObject("$sum", (Object)1));
            BasicDBObject group = new BasicDBObject("$group", (Object)groupFields);
            AggregationOutput output = null;
            if (map.get(key).equalsIgnoreCase("facet.array")) {
                unwindFields.put("$unwind", (Object)("$" + key));
                output = this.serviceCollection.aggregate((DBObject)match, new DBObject[]{unwindFields, project, group});
            } else if (map.get(key).equalsIgnoreCase("facet.simple")) {
                output = this.serviceCollection.aggregate((DBObject)match, new DBObject[]{project, group});
            }
            Iterable it = output.results();
            JSONArray terms = new JSONArray();
            for (DBObject dbObject : it) {
                JSONObject term = new JSONObject(JSON.serialize((Object)dbObject));
                terms.put((Object)term);
            }
            JSONObject attrName = new JSONObject();
            attrName.put(key, (Object)terms);
            ja.put((Object)attrName);
        }
        return ja;
    }

    public boolean isVersionNumber241OrGreater() {
        Version v = new Version(2, 4, 1, null);
        return VersionUtil.parseVersion((String)this.getDBVersion()).compareTo(v) >= 0;
    }
}

