/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.core;

import com.mongodb.MongoException;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.glue2.Glue2Mapper;
import eu.emi.emir.client.glue2.JSONToGlue2MappingException;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.db.PersistentStoreFailureException;
import eu.emi.emir.db.QueryException;
import eu.emi.emir.db.ServiceDatabase;
import eu.emi.emir.db.mongodb.MongoDBServiceDatabase;
import eu.eu_emi.emiregistry.QueryResult;
import java.text.ParseException;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ServiceColManager {
    private static final Logger logger = Log.getLogger((String)"emir.core", ServiceColManager.class);
    private ServiceDatabase serviceDB = null;
    public static final String SKIP = "skip";
    public static final String LIMIT = "limit";
    public static final String PAGE_SIZE = "pageSize";
    public static final String REF = "ref";

    public ServiceColManager() {
        this.serviceDB = new MongoDBServiceDatabase();
    }

    public ServiceColManager(MongoDBServiceDatabase mongodb) {
        this.serviceDB = mongodb;
    }

    public JSONArray getServiceReferences() throws JSONException, QueryException, PersistentStoreFailureException {
        JSONArray arr = new JSONArray();
        arr = this.serviceDB.queryDistinctJSON(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName());
        return arr;
    }

    public JSONArray getServicesByType(String serviceType) throws JSONException, QueryException, PersistentStoreFailureException {
        if (serviceType.isEmpty()) {
            throw new IllegalArgumentException("\"servicetype\" is not defined");
        }
        JSONArray arr = new JSONArray();
        arr = this.serviceDB.queryJSON("{\"" + ServiceBasicAttributeNames.SERVICE_TYPE.getAttributeName() + "\":\"" + serviceType + "\"}");
        return arr;
    }

    public JSONArray getDistinctTypes() throws JSONException, QueryException, PersistentStoreFailureException {
        JSONArray arr = new JSONArray();
        arr = this.serviceDB.queryDistinctJSON(ServiceBasicAttributeNames.SERVICE_TYPE.getAttributeName());
        return arr;
    }

    public JSONArray queryForJSON(Map<String, Object> m) throws QueryException, PersistentStoreFailureException, MongoException, JSONException {
        JSONArray jArr = this.queryForJSON(null, m);
        return jArr;
    }

    public JSONArray queryForJSON(JSONObject jo, Map<String, Object> m) throws QueryException, PersistentStoreFailureException, MongoException, JSONException {
        JSONArray jArr = null;
        jArr = m.get(LIMIT) != null || m.get(SKIP) != null ? this.queryWithSkipOrLimit(jo, m) : this.pagedQueryForJSON(jo, m);
        return jArr;
    }

    public QueryResult queryForXML(Map<String, Object> m) throws QueryException, PersistentStoreFailureException, JSONException, DatatypeConfigurationException, ParseException, JSONToGlue2MappingException {
        QueryResult qr = this.queryForXML(null, m);
        return qr;
    }

    public QueryResult queryForXML(JSONObject jo, Map<String, Object> m) throws QueryException, PersistentStoreFailureException, JSONException, DatatypeConfigurationException, ParseException, JSONToGlue2MappingException {
        QueryResult qr = null;
        if (m.get(PAGE_SIZE) != null && Integer.valueOf(m.get(PAGE_SIZE).toString()) <= 0) {
            return new QueryResult();
        }
        qr = m.get(LIMIT) != null || m.get(SKIP) != null ? this.queryGlue2(m) : this.pagedQueryForXML(jo, m);
        return qr;
    }

    private JSONArray queryWithSkipOrLimit(JSONObject queryDoc, Map<String, Object> m) throws QueryException, PersistentStoreFailureException, MongoException, JSONException {
        JSONArray jArr;
        Integer limit = 0;
        Integer skip = 0;
        String keyLimit = LIMIT;
        String keySkip = SKIP;
        limit = m.get(keyLimit) != null ? Integer.valueOf(m.get(keyLimit).toString()) : 0;
        skip = m.get(keySkip) != null ? Integer.valueOf(m.get(keySkip).toString()) : 0;
        if (queryDoc == null) {
            queryDoc = new JSONObject(m);
        }
        if (limit > 0 && skip > 0) {
            queryDoc.remove(LIMIT);
            queryDoc.remove(SKIP);
            jArr = this.serviceDB.queryJSON(queryDoc.toString(), limit, skip);
        } else if (limit > 0) {
            queryDoc.remove(LIMIT);
            jArr = this.serviceDB.queryJSONWithLimit(queryDoc.toString(), limit);
        } else if (skip > 0) {
            queryDoc.remove(SKIP);
            jArr = this.serviceDB.queryJSON(queryDoc.toString(), skip);
        } else {
            jArr = this.serviceDB.queryJSON(queryDoc.toString());
        }
        return jArr;
    }

    private QueryResult queryGlue2(Map<String, Object> m) throws QueryException, PersistentStoreFailureException, JSONException, DatatypeConfigurationException, ParseException, JSONToGlue2MappingException {
        JSONArray ja = this.queryForJSON(m);
        Glue2Mapper gm = new Glue2Mapper();
        QueryResult qr = gm.toQueryResult(ja);
        return qr;
    }

    @Deprecated
    public JSONArray pagedQueryForJSON(Map<String, Object> m) throws JSONException {
        JSONArray jArr = this.pagedQueryForJSON(null, m);
        return jArr;
    }

    private JSONArray pagedQueryForJSON(JSONObject queryDoc, Map<String, Object> m) throws JSONException {
        Integer pageSize = 0;
        String ref = null;
        pageSize = m.get(PAGE_SIZE) != null ? Integer.valueOf(m.get(PAGE_SIZE).toString()) : 100;
        if (pageSize <= 0) {
            return new JSONArray();
        }
        String string = ref = m.get(REF) != null ? m.get(REF).toString() : null;
        if (queryDoc == null) {
            queryDoc = new JSONObject(m);
        }
        queryDoc.remove(PAGE_SIZE);
        queryDoc.remove(REF);
        JSONArray jArr = queryDoc.length() > 0 ? this.serviceDB.paginatedQuery(queryDoc.toString(), pageSize, ref) : this.serviceDB.paginatedQuery("{}", pageSize, ref);
        if (jArr.length() == 0) {
            return new JSONArray();
        }
        if (jArr.length() == pageSize.intValue()) {
            JSONObject doc = new JSONObject(jArr.get(jArr.length() - 1).toString());
            JSONObject refObj = new JSONObject();
            refObj.put(REF, doc.getJSONObject("_id").get("$oid"));
            jArr.put((Object)refObj);
        }
        return jArr;
    }

    private QueryResult pagedQueryForXML(JSONObject queryDoc, Map<String, Object> m) throws JSONException, JSONToGlue2MappingException {
        Glue2Mapper gm = new Glue2Mapper();
        QueryResult qr = gm.toQueryResult(this.pagedQueryForJSON(queryDoc, m));
        return qr;
    }

    public Long getTotalNumberOfEntries() {
        return this.serviceDB.size();
    }
}

