/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.trust;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.WeakTimerTask;
import eu.emi.security.authn.x509.helpers.trust.TrustAnchorStore;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Timer;
import java.util.TimerTask;

public abstract class TrustAnchorStoreBase
implements TrustAnchorStore {
    protected final ObserversHandler observers;
    private Timer timer;
    private long updateInterval;

    public TrustAnchorStoreBase(Timer timer, long updateInterval, ObserversHandler observers) {
        this.timer = timer;
        this.observers = observers;
        this.updateInterval = updateInterval;
    }

    public synchronized long getUpdateInterval() {
        return this.updateInterval;
    }

    public synchronized void setUpdateInterval(long newInterval) {
        long old = this.getUpdateInterval();
        this.updateInterval = newInterval;
        if (old <= 0L) {
            this.scheduleUpdate();
        }
    }

    protected void scheduleUpdate() {
        long updateInterval = this.getUpdateInterval();
        if (updateInterval > 0L) {
            this.timer.schedule((TimerTask)new AsyncTrustAnchorsUpdateTask(this), updateInterval);
        }
    }

    protected abstract void update();

    @Override
    public void dispose() {
        this.setUpdateInterval(-1L);
    }

    protected void checkValidity(String location, X509Certificate certificate, boolean addSubject) {
        try {
            certificate.checkValidity();
        }
        catch (CertificateExpiredException e) {
            StringBuilder sb = TrustAnchorStoreBase.prepErrorMsgPfx(certificate, addSubject);
            sb.append(" is EXPIRED: ").append(e.getMessage());
            this.observers.notifyObservers(location, "CA Certificate", StoreUpdateListener.Severity.WARNING, new Exception(sb.toString()));
        }
        catch (CertificateNotYetValidException e) {
            StringBuilder sb = TrustAnchorStoreBase.prepErrorMsgPfx(certificate, addSubject);
            sb.append(" is NOT YET VALID: ").append(e.getMessage());
            this.observers.notifyObservers(location, "CA Certificate", StoreUpdateListener.Severity.WARNING, new Exception(sb.toString()));
        }
    }

    private static StringBuilder prepErrorMsgPfx(X509Certificate certificate, boolean addSubject) {
        StringBuilder sb = new StringBuilder();
        sb.append("Trusted CA certificate");
        if (addSubject) {
            sb.append(" with subject ");
            sb.append(X500NameUtils.getReadableForm(certificate.getSubjectX500Principal()));
        }
        return sb;
    }

    private static class AsyncTrustAnchorsUpdateTask
    extends WeakTimerTask<TrustAnchorStoreBase> {
        public AsyncTrustAnchorsUpdateTask(TrustAnchorStoreBase partner) {
            super(partner);
        }

        @Override
        public void run() {
            TrustAnchorStoreBase partner = (TrustAnchorStoreBase)this.partnerRef.get();
            if (partner == null) {
                return;
            }
            try {
                if (partner.getUpdateInterval() > 0L) {
                    partner.update();
                }
                partner.scheduleUpdate();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }
}

