/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.client.util;

import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.LogManager;
import org.apache.log4j.PropertyConfigurator;

public class ServiceUtil {
    private static List<String> lstAttributeNames = null;

    private static synchronized void initList() {
        lstAttributeNames = new CopyOnWriteArrayList<String>();
        for (ServiceBasicAttributeNames s : ServiceBasicAttributeNames.values()) {
            lstAttributeNames.add(s.getAttributeName());
        }
    }

    public static List<String> getAttributeNames() {
        if (lstAttributeNames == null) {
            ServiceUtil.initList();
        }
        return Collections.unmodifiableList(lstAttributeNames);
    }

    public static void initLogger(String path) {
        if (path == null) {
            return;
        }
        PropertyConfigurator.configure((String)path);
        LogManager l = LogManager.getLogManager();
        try {
            l.readConfiguration(new FileInputStream(new File(path)));
        }
        catch (SecurityException e) {
            Log.logException((String)"", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            Log.logException((String)"", (Throwable)e);
        }
        catch (IOException e) {
            Log.logException((String)"", (Throwable)e);
        }
    }
}

