/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.query.URIQuery;
import eu.emi.emir.client.util.ExtentedMultiValuedMapImpl;
import eu.emi.emir.client.util.Log;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import eu.eu_emi.emiregistry.QueryResult;
import eu.unicore.security.canl.LoggingX509TrustManager;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.Serializable;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class EMIRClient
implements Serializable {
    private static final long serialVersionUID = 8744557209419461238L;
    private final String url;
    private static final Logger logger = Log.getLogger((String)"emir.client", EMIRClient.class);
    private Client cr = null;
    private IClientConfiguration clientConfig = null;

    public EMIRClient(String url, IClientConfiguration clientConfig) {
        logger.debug((Object)"creating ssl client");
        this.clientConfig = clientConfig;
        this.url = url;
        this.initSec();
    }

    private void initSec() {
        DefaultClientConfig config = new DefaultClientConfig();
        SSLContext ctx = null;
        try {
            ctx = this.createSSLContext((X509CertChainValidator)this.clientConfig.getValidator(), this.clientConfig.getCredential(), "SSL", null, new SecureRandom().getAlgorithm());
        }
        catch (Exception e) {
            Log.logException((String)"Error initializing the Security - check security configuration", (Throwable)e, (Logger)logger);
        }
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        };
        config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(hv, ctx));
        this.cr = Client.create((ClientConfig)config);
    }

    private SSLContext createSSLContext(X509CertChainValidator validator, X509Credential credential, String protocol, String provider, String secRandomAlg) throws NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)credential.getKeyStore().getCertificate("NOT_SET"));
            }
        }
        catch (KeyStoreException e) {
            Log.logException((String)"Error creating the SSL context", (Throwable)e, (Logger)logger);
        }
        KeyManager[] keyManagers = new KeyManager[]{credential.getKeyManager()};
        X509TrustManager trustManager = SocketFactoryCreator.getSSLTrustManager((X509CertChainValidator)validator);
        LoggingX509TrustManager decoratedTrustManager = new LoggingX509TrustManager(trustManager, "HTTP Client");
        TrustManager[] trustManagers = new X509TrustManager[]{decoratedTrustManager};
        SecureRandom secureRandom = secRandomAlg == null ? null : SecureRandom.getInstance(secRandomAlg);
        SSLContext context = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
        context.init(keyManagers, trustManagers, secureRandom);
        return context;
    }

    public EMIRClient(String url) {
        logger.debug((Object)"creating default client");
        this.url = url;
        this.cr = Client.create();
        this.cr.setConnectTimeout(Integer.valueOf(3000));
    }

    public WebResource getClientResource() {
        return this.cr.resource(this.url);
    }

    public Client getClient() {
        return this.cr;
    }

    public JSONArray register(JSONArray ja) {
        ClientResponse res = (ClientResponse)this.getClientResource().path("serviceadmin").accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(ClientResponse.class, (Object)ja);
        return (JSONArray)res.getEntity(JSONArray.class);
    }

    public JSONArray update(JSONArray ja) {
        ClientResponse res = (ClientResponse)this.getClientResource().path("serviceadmin").accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(ClientResponse.class, (Object)ja);
        return (JSONArray)res.getEntity(JSONArray.class);
    }

    public ClientResponse deleteByID(String endpointId) {
        ClientResponse res = (ClientResponse)this.getClientResource().path("serviceadmin").queryParam(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), endpointId).delete(ClientResponse.class);
        return res;
    }

    public JSONArray queryByQueryParams(MultivaluedMap<String, String> attrMap) {
        JSONArray ja = null;
        ja = attrMap != null ? (JSONArray)this.getClientResource().path("services").queryParams(attrMap).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JSONArray.class) : (JSONArray)this.getClientResource().path("services").accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JSONArray.class);
        return ja;
    }

    public JSONArray queryByQueryParams(URIQuery query) {
        JSONArray ja = null;
        if (query != null) {
            MultivaluedMap<String, String> attrMap = query.getMultiValuedMap();
            ja = (JSONArray)this.getClientResource().path("services").queryParams(attrMap).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JSONArray.class);
        } else {
            ja = (JSONArray)this.getClientResource().path("services").accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JSONArray.class);
        }
        return ja;
    }

    public JSONArray richQueryForJSON(JSONObject queryDocument) {
        return this.richQueryForJSON(queryDocument, null);
    }

    public JSONArray richQueryForJSON(JSONObject queryDocument, Integer pageSize) {
        if (pageSize == null || pageSize == 0) {
            pageSize = 100;
        }
        return (JSONArray)this.getClientResource().path("services").queryParam("pageSize", pageSize.toString()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(JSONArray.class, (Object)queryDocument);
    }

    public QueryResult richQueryForXML(JSONObject queryDocument) {
        return this.richQueryForXML(queryDocument, null);
    }

    public QueryResult richQueryForXML(JSONObject queryDocument, Integer pageSize) {
        if (pageSize == null || pageSize == 0) {
            pageSize = 100;
        }
        return (QueryResult)this.getClientResource().path("services").queryParam("pageSize", pageSize.toString()).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).post(QueryResult.class, (Object)queryDocument);
    }

    public QueryResult queryXML(MultivaluedMap<String, String> attrMap, Integer skip, Integer limit) {
        QueryResult ja = (QueryResult)this.getClientResource().path("services").queryParams(attrMap).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(QueryResult.class);
        return ja;
    }

    public JSONArray facetSearch(Map<String, String> facetMap) {
        ExtentedMultiValuedMapImpl map = new ExtentedMultiValuedMapImpl();
        map.putAllMap(facetMap);
        JSONArray result = (JSONArray)this.getClientResource().path("services/facet").queryParams((MultivaluedMap)map).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JSONArray.class);
        return result;
    }

    public Boolean isReachable() {
        JSONObject j = null;
        try {
            j = (JSONObject)this.getClientResource().path("ping").get(JSONObject.class);
        }
        catch (Exception e) {
            return false;
        }
        boolean status = j != null;
        return status;
    }

    public String getEmirUrl() {
        return this.url;
    }
}

