/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBMarshallerConfiguration {
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String FILE_PREFIX = "file:";
    private static final String URL_PREFIX = "url:";
    private boolean formattedOutput;
    private boolean fragment;
    private boolean writeSchemaLocation;
    private List<String> schemaLocation;
    private Schema schema;
    private boolean validateParsing;
    private boolean validateWriting;
    ValidationEventHandler validationEventHandler;
    private final Logger logger = LoggerFactory.getLogger(JAXBMarshallerConfiguration.class);

    public ValidationEventHandler getValidationEventHandler() {
        return this.validationEventHandler;
    }

    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
    }

    public boolean isFormattedOutput() {
        return this.formattedOutput;
    }

    public void setFormattedOutput(boolean formattedOutput) {
        this.formattedOutput = formattedOutput;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public void setFragment(boolean fragment) {
        this.fragment = fragment;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchemaByPath(String schemaPath) throws SAXException, MalformedURLException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        String schema = schemaPath.trim();
        if (schema.regionMatches(true, 0, URL_PREFIX, 0, URL_PREFIX.length())) {
            URL url = new URL(schema.substring(URL_PREFIX.length()));
            this.schema = this.createSchema(sf, new StreamSource(url.toExternalForm()));
        } else if (schema.regionMatches(true, 0, FILE_PREFIX, 0, FILE_PREFIX.length())) {
            File file = new File(schema.substring(FILE_PREFIX.length()));
            this.schema = this.createSchema(sf, new StreamSource(file));
        } else if (schema.regionMatches(true, 0, CLASSPATH_PREFIX, 0, CLASSPATH_PREFIX.length())) {
            URL url = this.getClass().getClassLoader().getResource(this.leadingSlash(schema.substring(CLASSPATH_PREFIX.length())));
            if (url == null) {
                throw new IllegalArgumentException(schema);
            }
            this.schema = this.createSchema(sf, new StreamSource(url.toExternalForm()));
        } else {
            URL url = this.getClass().getClassLoader().getResource(this.leadingSlash(schema));
            if (url == null) {
                throw new IllegalArgumentException(schema);
            }
            this.schema = this.createSchema(sf, new StreamSource(url.toExternalForm()));
        }
    }

    private Schema createSchema(SchemaFactory sf, Source source) {
        try {
            return sf.newSchema(source);
        }
        catch (SAXException e) {
            this.setValidateParsing(false);
            this.setValidateWriting(false);
            this.logger.warn("Validating turned off because schema could not be initialized.");
            return null;
        }
    }

    private String leadingSlash(String input) {
        if (input.startsWith("/")) {
            return input;
        }
        return "/" + input;
    }

    public String getSchemaLocationAsString() {
        StringBuilder sb = new StringBuilder();
        for (String str : this.schemaLocation) {
            sb.append(str);
            sb.append(" ");
        }
        return sb.toString();
    }

    public void setSchemaLocation(List<String> schemaLocation) {
        this.schemaLocation = new ArrayList<String>();
        for (String str : schemaLocation) {
            this.schemaLocation.add(str.trim());
        }
    }

    public boolean isValidateParsing() {
        return this.validateParsing;
    }

    public void setValidateParsing(boolean validate) {
        this.validateParsing = validate;
    }

    public boolean isValidateWriting() {
        return this.validateWriting;
    }

    public void setValidateWriting(boolean validateWriting) {
        this.validateWriting = validateWriting;
    }

    public boolean isWriteSchemaLocation() {
        return this.writeSchemaLocation;
    }

    public void setWriteSchemaLocation(boolean writeSchemaLocation) {
        this.writeSchemaLocation = writeSchemaLocation;
    }
}

