/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

public class PortRange {
    private static final String MATCHPATTERN = "(([1-9]\\d*)??\\-??([1-9]\\d*)??)??";
    private static final int UPPER_BOUNDARY = 65535;
    private static final int LOWER_BOUNDARY = 1;
    private int lowerValue = 1;
    private int upperValue = 65535;

    public PortRange(String portRange) {
        if (!portRange.matches(MATCHPATTERN)) {
            throw new IllegalArgumentException("No port range: " + portRange);
        }
        int position = portRange.indexOf("-");
        if (position == -1) {
            try {
                this.lowerValue = this.upperValue = Integer.valueOf(portRange.substring(0, portRange.length())).intValue();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("No port range: " + portRange);
            }
        }
        try {
            String value = portRange.substring(0, position);
            if (!value.equals("")) {
                this.lowerValue = new Integer(value);
            }
            if (!(value = portRange.substring(position + 1, portRange.length())).equals("")) {
                this.upperValue = new Integer(value);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("No port range: " + portRange);
        }
        if (this.lowerValue < 0) {
            throw new IllegalArgumentException("No port range: " + portRange);
        }
        if (this.upperValue - this.lowerValue < 0) {
            throw new IllegalArgumentException("No port range: " + portRange);
        }
        if (this.upperValue > 65535) {
            throw new IllegalArgumentException("No port range: " + portRange);
        }
    }

    public String toString() {
        if (this.upperValue != this.lowerValue) {
            return this.lowerValue + "-" + this.upperValue;
        }
        return Integer.toString(this.lowerValue);
    }
}

