/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.policy.impl;

import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.impl.AttributeValueType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.converter.URNToDataTypeConverter;
import org.herasaf.xacml.core.dataTypeAttribute.DataTypeAttribute;
import org.herasaf.xacml.core.policy.ExpressionProcessingException;
import org.herasaf.xacml.core.policy.MissingAttributeException;
import org.herasaf.xacml.core.policy.impl.ActionAttributeDesignatorType;
import org.herasaf.xacml.core.policy.impl.EnvironmentAttributeDesignatorType;
import org.herasaf.xacml.core.policy.impl.ExpressionType;
import org.herasaf.xacml.core.policy.impl.ResourceAttributeDesignatorType;
import org.herasaf.xacml.core.policy.impl.SubjectAttributeDesignatorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@XmlType(name="AttributeDesignatorType")
@XmlSeeAlso(value={SubjectAttributeDesignatorType.class, ResourceAttributeDesignatorType.class, EnvironmentAttributeDesignatorType.class, ActionAttributeDesignatorType.class})
public abstract class AttributeDesignatorType
extends ExpressionType {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="AttributeId", required=true)
    @XmlSchemaType(name="anyURI")
    private String attributeId;
    @XmlAttribute(name="DataType", required=true)
    @XmlJavaTypeAdapter(value=URNToDataTypeConverter.class)
    @XmlSchemaType(name="anyURI")
    private DataTypeAttribute<?> dataType;
    @XmlAttribute(name="Issuer")
    private String issuer;
    @XmlAttribute(name="MustBePresent")
    private Boolean mustBePresent;

    public String getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(String value) {
        this.attributeId = value;
    }

    public DataTypeAttribute<?> getDataType() {
        return this.dataType;
    }

    public void setDataType(DataTypeAttribute<?> value) {
        this.dataType = value;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String value) {
        this.issuer = value;
    }

    public boolean isMustBePresent() {
        if (this.mustBePresent == null) {
            return false;
        }
        return this.mustBePresent;
    }

    public void setMustBePresent(Boolean value) {
        this.mustBePresent = value;
    }

    @Override
    public abstract Object handle(RequestType var1, EvaluationContext var2) throws ExpressionProcessingException, MissingAttributeException, SyntaxException;

    protected void addAndConvertAttrValue(List<Object> returnValues, List<AttributeValueType> attrValues) throws ExpressionProcessingException, SyntaxException {
        for (AttributeValueType attrVal : attrValues) {
            if (attrVal.getContent().size() > 1) {
                throw new ExpressionProcessingException("The content of the AttributeValueType can't be greater than 1");
            }
            try {
                returnValues.add(this.dataType.convertTo((String)attrVal.getContent().get(0)));
            }
            catch (ClassCastException e) {
                throw new SyntaxException(e);
            }
        }
    }
}

