/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.impl;

import eu.emi.security.authn.x509.helpers.JavaAndBCStyle;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.util.Strings;

public class OpensslNameUtils {
    public static final Map<String, String> NORMALIZED_LABELS = new HashMap<String, String>();

    private static String normalizeLabel(String label) {
        String normalized = NORMALIZED_LABELS.get(label.toLowerCase());
        return normalized == null ? label : normalized;
    }

    public static String normalize(String legacyDN) {
        Pattern p = Pattern.compile("/[^=]+=");
        Matcher m = p.matcher(legacyDN);
        StringBuilder output = new StringBuilder();
        int i = 0;
        while (m.find()) {
            output.append(legacyDN.substring(i, m.start()));
            String group = m.group();
            String label = group.substring(1, group.length() - 1);
            label = OpensslNameUtils.normalizeLabel(label);
            output.append("/");
            output.append(label);
            output.append("=");
            i = m.end();
        }
        output.append(legacyDN.substring(i, legacyDN.length()));
        return output.toString().toLowerCase();
    }

    public static String convertFromRfc2253(String srcDn, boolean globusFlavouring) {
        String avasSeparator = globusFlavouring ? "+" : "/";
        JavaAndBCStyle style = new JavaAndBCStyle();
        X500Name x500Name = new X500Name((X500NameStyle)style, srcDn);
        RDN[] rdns = x500Name.getRDNs();
        StringBuilder ret = new StringBuilder();
        for (int i = rdns.length - 1; i >= 0; --i) {
            ret.append("/");
            RDN rdn = rdns[i];
            AttributeTypeAndValue[] atvs = rdn.getTypesAndValues();
            for (int j = atvs.length - 1; j >= 0; --j) {
                AttributeTypeAndValue atv = atvs[j];
                ret.append(OpensslNameUtils.getShortName4Openssl(atv.getType()));
                ret.append("=");
                ret.append(OpensslNameUtils.getOpensslValue(atv.getValue()));
                if (j <= 0) continue;
                ret.append(avasSeparator);
            }
        }
        return ret.toString();
    }

    private static String getShortName4Openssl(ASN1ObjectIdentifier id) {
        JavaAndBCStyle style = new JavaAndBCStyle();
        String name = style.getLabelForOidFull(id);
        if (name == null) {
            return id.getId();
        }
        return OpensslNameUtils.normalizeLabel(name);
    }

    private static String getOpensslValue(ASN1Encodable val) {
        byte[] bytes;
        if (val instanceof DERBitString) {
            bytes = ((DERBitString)val).getBytes();
        } else if (val instanceof DERString) {
            String valS = ((DERString)val).getString();
            char[] chars = valS.toCharArray();
            bytes = Strings.toUTF8ByteArray((char[])chars);
        } else {
            throw new IllegalArgumentException("Got AVA value of unsupported type: " + val.getClass().getName());
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            if (b <= 31) {
                sb.append("\\x" + Integer.toHexString(b & 0xFF).toUpperCase());
                continue;
            }
            sb.append((char)b);
        }
        return sb.toString();
    }

    static {
        NORMALIZED_LABELS.put("e", "emailAddress");
        NORMALIZED_LABELS.put("email", "emailAddress");
        NORMALIZED_LABELS.put("userid", "UID");
        NORMALIZED_LABELS.put("sn", "serialnumber");
        NORMALIZED_LABELS.put("surname", "sn");
        NORMALIZED_LABELS.put("givenname", "gn");
        NORMALIZED_LABELS.put("dn", "dnQualifier");
        NORMALIZED_LABELS.put("dnq", "dnQualifier");
        NORMALIZED_LABELS.put("uniqueidentifier", "x500UniqueIdentifier");
        NORMALIZED_LABELS.put("generation", "generationQualifier");
        NORMALIZED_LABELS.put("s", "ST");
        NORMALIZED_LABELS.put("ip", "1.3.6.1.4.1.42.2.11.2.1");
        NORMALIZED_LABELS.put("nameatbirth", "1.3.36.8.3.14");
    }
}

