/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.impl;

import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.ValidationResult;
import eu.emi.security.authn.x509.helpers.crl.OpensslCRLStoreSpi;
import eu.emi.security.authn.x509.helpers.ns.NamespaceChecker;
import eu.emi.security.authn.x509.helpers.pkipath.AbstractValidator;
import eu.emi.security.authn.x509.helpers.trust.OpensslTrustAnchorStore;
import eu.emi.security.authn.x509.impl.ValidatorParams;
import eu.emi.security.authn.x509.impl.ValidatorParamsExt;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Timer;

public class OpensslCertChainValidator
extends AbstractValidator {
    private OpensslTrustAnchorStore trustStore;
    private OpensslCRLStoreSpi crlStore;
    private NamespaceCheckingMode namespaceMode;
    private String path;
    private Timer timer;

    public OpensslCertChainValidator(String directory, NamespaceCheckingMode namespaceMode, long updateInterval, ValidatorParams params) {
        super(params.getInitialListeners());
        this.path = directory;
        this.namespaceMode = namespaceMode;
        this.timer = new Timer("caNl validator (openssl) timer", true);
        this.trustStore = new OpensslTrustAnchorStore(directory, this.timer, updateInterval, namespaceMode.globusEnabled(), namespaceMode.euGridPmaEnabled(), this.observers);
        try {
            this.crlStore = new OpensslCRLStoreSpi(directory, updateInterval, this.timer, this.observers);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("BUG: OpensslCRLStoreSpi can not be initialized", e);
        }
        this.init(this.trustStore, this.crlStore, params.isAllowProxy(), params.getRevocationSettings());
    }

    public OpensslCertChainValidator(String directory, NamespaceCheckingMode namespaceMode, long updateInterval) {
        this(directory, namespaceMode, updateInterval, new ValidatorParams());
    }

    public OpensslCertChainValidator(String directory) {
        this(directory, NamespaceCheckingMode.EUGRIDPMA_GLOBUS, 600000L, new ValidatorParamsExt());
    }

    public String getTruststorePath() {
        return this.path;
    }

    public NamespaceCheckingMode getNamespaceCheckingMode() {
        return this.namespaceMode;
    }

    public long getUpdateInterval() {
        return this.trustStore.getUpdateInterval();
    }

    public void setUpdateInterval(long updateInterval) {
        this.trustStore.setUpdateInterval(updateInterval);
        this.crlStore.setUpdateInterval(updateInterval);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.trustStore.dispose();
        this.crlStore.dispose();
        this.timer.cancel();
    }

    @Override
    public synchronized ValidationResult validate(X509Certificate[] certChain) {
        ValidationResult result = super.validate(certChain);
        NamespaceChecker checker = new NamespaceChecker(this.namespaceMode, this.trustStore.getPmaNsStore(), this.trustStore.getGlobusNsStore());
        List<ValidationError> errors = checker.check(certChain);
        this.processErrorList(errors);
        result.addErrors(errors);
        return result;
    }
}

