/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.impl;

import eu.emi.security.authn.x509.helpers.CachedPEMReader;
import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import eu.emi.security.authn.x509.helpers.CharArrayPasswordFinder;
import eu.emi.security.authn.x509.helpers.FlexiblePEMReader;
import eu.emi.security.authn.x509.helpers.KeyStoreHelper;
import eu.emi.security.authn.x509.helpers.PKCS8DERReader;
import eu.emi.security.authn.x509.impl.FormatMode;
import eu.emi.security.authn.x509.impl.X509Formatter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.crypto.BadPaddingException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.PKCS8Generator;
import org.bouncycastle.util.io.pem.PemGenerationException;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class CertificateUtils {
    public static final String DEFAULT_KEYSTORE_ALIAS = "default";
    public static final Charset ASCII;

    public static void configureSecProvider() {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static X509Certificate[] convertToX509Chain(Certificate[] chain) throws ClassCastException {
        X509Certificate[] ret = new X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            ret[i] = (X509Certificate)chain[i];
        }
        return ret;
    }

    public static String format(X509Certificate cert, FormatMode mode) {
        X509Formatter formatter = new X509Formatter(mode);
        return formatter.format(cert);
    }

    public static String format(X509Certificate[] certChain, FormatMode mode) {
        X509Formatter formatter = new X509Formatter(mode);
        return formatter.format(certChain);
    }

    public static X509Certificate loadCertificate(InputStream is, Encoding format) throws IOException {
        X509Certificate[] certs = CertificateUtils.loadCertificateChain(is, format);
        if (certs.length != 1) {
            throw new IOException("The PEM contains more than one certificate");
        }
        return certs[0];
    }

    public static PrivateKey loadPrivateKey(InputStream is, Encoding format, char[] password) throws IOException {
        if (format.equals((Object)Encoding.PEM)) {
            CharArrayPasswordFinder pf = password == null ? null : new CharArrayPasswordFinder(password);
            InputStreamReader reader = new InputStreamReader(is, Charset.forName("US-ASCII"));
            FlexiblePEMReader pemReader = new FlexiblePEMReader(reader, pf);
            return CertificateUtils.internalLoadPK(pemReader, "PEM");
        }
        return CertificateUtils.loadDERPrivateKey(is, password);
    }

    private static PrivateKey parsePEMPrivateKey(PemObject pem, char[] password) throws IOException {
        CharArrayPasswordFinder pf = password == null ? null : new CharArrayPasswordFinder(password);
        CachedPEMReader pemReader = new CachedPEMReader(pem, pf);
        return CertificateUtils.internalLoadPK(pemReader, "PEM");
    }

    private static PrivateKey internalLoadPK(PEMReader pemReader, String type) throws IOException {
        Object ret = null;
        try {
            ret = pemReader.readObject();
        }
        catch (IOException e) {
            if (e.getCause() != null && e.getCause() instanceof BadPaddingException) {
                throw new IOException("Can not load " + type + " private key: the password is " + "incorrect or the " + type + " data is corrupted.", e);
            }
            throw new IOException("Can not load the " + type + " private key: " + e);
        }
        if (ret instanceof PrivateKey) {
            return (PrivateKey)ret;
        }
        if (ret instanceof KeyPair) {
            KeyPair kp = (KeyPair)ret;
            return kp.getPrivate();
        }
        throw new IOException("The " + type + " input does not contain a private key, " + "it was parsed as " + ret.getClass().getName());
    }

    private static PrivateKey loadDERPrivateKey(InputStream is, char[] password) throws IOException {
        CharArrayPasswordFinder pf = password == null ? null : new CharArrayPasswordFinder(password);
        PKCS8DERReader derReader = new PKCS8DERReader(is, pf);
        return CertificateUtils.internalLoadPK(derReader, "DER");
    }

    public static X509Certificate[] loadCertificateChain(InputStream is, Encoding format) throws IOException {
        InputStream realIS = is;
        if (format.equals((Object)Encoding.PEM)) {
            boolean readOne = false;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
            InputStreamReader br = new InputStreamReader(is, ASCII);
            FlexiblePEMReader pemReader = new FlexiblePEMReader(br);
            while (true) {
                PemObject pem;
                if ((pem = pemReader.readPemObject()) == null && !readOne) {
                    throw new IOException("PEM data not found in the stream and its end was reached");
                }
                if (pem == null) break;
                CertificateHelpers.PEMContentsType type = CertificateHelpers.getPEMType(pem.getType());
                if (!type.equals((Object)CertificateHelpers.PEMContentsType.CERTIFICATE)) {
                    throw new IOException("Expected PEM encoded certificate but found: " + (Object)((Object)type));
                }
                readOne = true;
                buffer.write(pem.getContent());
            }
            realIS = new ByteArrayInputStream(buffer.toByteArray());
        }
        return CertificateUtils.loadDERCertificateChain(realIS);
    }

    private static X509Certificate[] loadDERCertificateChain(InputStream is) throws IOException {
        Collection<? extends Certificate> certs = CertificateHelpers.readDERCertificates(is);
        Iterator<? extends Certificate> iterator = certs.iterator();
        X509Certificate[] ret = new X509Certificate[certs.size()];
        for (int i = 0; i < ret.length; ++i) {
            Certificate c = iterator.next();
            if (!(c instanceof X509Certificate)) {
                throw new IOException("The PEM contains a certificate which is not a X.509Certificate, it is " + c.getClass().getName());
            }
            ret[i] = (X509Certificate)c;
        }
        return ret;
    }

    public static KeyStore loadPEMKeystore(InputStream is, char[] password, char[] ksPassword) throws IOException {
        KeyStore ks;
        PemObject pem;
        PrivateKey pk = null;
        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
        InputStreamReader br = new InputStreamReader(is, ASCII);
        FlexiblePEMReader pemReader = new FlexiblePEMReader(br);
        while ((pem = pemReader.readPemObject()) != null) {
            CertificateHelpers.PEMContentsType type = CertificateHelpers.getPEMType(pem.getType());
            if (type.equals((Object)CertificateHelpers.PEMContentsType.PRIVATE_KEY) || type.equals((Object)CertificateHelpers.PEMContentsType.LEGACY_OPENSSL_PRIVATE_KEY)) {
                if (pk != null) {
                    throw new IOException("Multiple private keys were found");
                }
                pk = CertificateUtils.parsePEMPrivateKey(pem, password);
                continue;
            }
            if (type.equals((Object)CertificateHelpers.PEMContentsType.CERTIFICATE)) {
                X509Certificate[] certs;
                for (X509Certificate cert : certs = CertificateUtils.loadDERCertificateChain(new ByteArrayInputStream(pem.getContent()))) {
                    certChain.add(cert);
                }
                continue;
            }
            throw new IOException("Unsupported PEM object found in the input: " + (Object)((Object)type));
        }
        if (pk == null) {
            throw new IOException("Private key was not found in the PEM keystore (" + certChain.size() + " certificate(s) was (were) found).");
        }
        Certificate[] chain = CertificateHelpers.sortChain(certChain);
        try {
            ks = KeyStoreHelper.getInstance("JKS");
            ks.load(null, null);
            ks.setKeyEntry(DEFAULT_KEYSTORE_ALIAS, pk, ksPassword, chain);
        }
        catch (KeyStoreException e) {
            throw new IOException("Can't setup the JKS keystore", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Can't setup the JKS keystore", e);
        }
        catch (CertificateException e) {
            throw new IOException("Can't setup the JKS keystore", e);
        }
        return ks;
    }

    public static void saveCertificate(OutputStream os, X509Certificate cert, Encoding format) throws IOException {
        if (format.equals((Object)Encoding.PEM)) {
            PEMWriter writer = new PEMWriter((Writer)new OutputStreamWriter(os, ASCII));
            writer.writeObject((Object)cert);
            writer.flush();
        } else {
            try {
                os.write(cert.getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new IOException("Can't encode the certificate into ASN.1 DER format", e);
            }
            os.flush();
        }
    }

    public static void savePrivateKey(OutputStream os, PrivateKey pk, Encoding format, String encryptionAlg, char[] encryptionPassword) throws IOException, IllegalArgumentException {
        PKCS8Generator gen;
        if (encryptionAlg != null) {
            try {
                gen = new PKCS8Generator(pk, encryptionAlg, BouncyCastleProvider.PROVIDER_NAME);
                gen.setPassword(encryptionPassword);
            }
            catch (NoSuchProviderException e) {
                throw new RuntimeException("UPS! Default provider is not known!", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Unknown encryption algorithm " + encryptionAlg, e);
            }
        } else {
            gen = new PKCS8Generator(pk);
        }
        if (format.equals((Object)Encoding.PEM)) {
            PemWriter writer = new PemWriter((Writer)new OutputStreamWriter(os, ASCII));
            writer.writeObject((PemObjectGenerator)gen);
            writer.flush();
        } else {
            if (encryptionAlg == null) {
                os.write(pk.getEncoded());
            } else {
                PemObject pemO = gen.generate();
                os.write(pemO.getContent());
            }
            os.flush();
        }
    }

    public static void saveCertificateChain(OutputStream os, X509Certificate[] chain, Encoding format) throws IOException {
        int i;
        byte[][] der = new byte[chain.length][];
        int total = 0;
        for (i = 0; i < chain.length; ++i) {
            try {
                der[i] = chain[i].getEncoded();
            }
            catch (CertificateEncodingException e) {
                throw new IOException("Can't encode the certificate into ASN1 DER format", e);
            }
            total += der[i].length;
        }
        if (format.equals((Object)Encoding.PEM)) {
            final byte[] finalBuf = new byte[total];
            int pos = 0;
            for (int i2 = 0; i2 < der.length; ++i2) {
                System.arraycopy(der[i2], 0, finalBuf, pos, der[i2].length);
                pos += der[i2].length;
            }
            PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(os, ASCII));
            pemWriter.writeObject(new PemObjectGenerator(){

                public PemObject generate() throws PemGenerationException {
                    return new PemObject("CERTIFICATE", finalBuf);
                }
            });
            pemWriter.flush();
        } else {
            for (i = 0; i < der.length; ++i) {
                os.write(der[i]);
            }
            os.flush();
        }
    }

    public static void savePEMKeystore(OutputStream os, KeyStore ks, String alias, String encryptionAlg, char[] keyPassword, char[] encryptionPassword) throws IOException, KeyStoreException, IllegalArgumentException, UnrecoverableKeyException, NoSuchAlgorithmException {
        Key k = ks.getKey(alias, keyPassword);
        if (k == null) {
            throw new IllegalArgumentException("The specified alias does not correspond to any key entry");
        }
        if (!(k instanceof PrivateKey)) {
            throw new IllegalArgumentException("The alias corresponds to a secret key, not to the private key");
        }
        CertificateUtils.savePrivateKey(os, (PrivateKey)k, Encoding.PEM, encryptionAlg, encryptionPassword);
        X509Certificate[] certs = CertificateUtils.convertToX509Chain(ks.getCertificateChain(alias));
        CertificateUtils.saveCertificateChain(os, certs, Encoding.PEM);
    }

    static {
        CertificateUtils.configureSecProvider();
        ASCII = Charset.forName("US-ASCII");
    }

    public static enum Encoding {
        PEM,
        DER;

    }
}

