/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ns;

import eu.emi.security.authn.x509.helpers.ns.GlobusNamespacesStore;
import eu.emi.security.authn.x509.helpers.ns.NamespacePolicy;
import eu.emi.security.authn.x509.helpers.trust.OpensslTrustAnchorStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public class EuGridPmaNamespacesStore
extends GlobusNamespacesStore {
    private Map<String, List<NamespacePolicy>> policiesByHash = new HashMap<String, List<NamespacePolicy>>();

    @Override
    public synchronized void setPolicies(List<NamespacePolicy> policies) {
        this.policiesByName = new HashMap(20);
        this.policiesByHash = new HashMap<String, List<NamespacePolicy>>();
        for (NamespacePolicy policy : policies) {
            if (policy.getIssuer().contains("=")) {
                this.addGlobusPolicy(policy);
                continue;
            }
            List<NamespacePolicy> current = this.policiesByHash.get(policy.getIssuer());
            if (current == null) {
                current = new ArrayList<NamespacePolicy>();
                this.policiesByHash.put(policy.getIssuer(), current);
            }
            current.add(policy);
        }
    }

    @Override
    public synchronized List<NamespacePolicy> getPolicies(X500Principal subject) {
        String hash;
        List<NamespacePolicy> p2;
        ArrayList<NamespacePolicy> policy = new ArrayList<NamespacePolicy>();
        List<NamespacePolicy> p1 = super.getPolicies(subject);
        if (p1 != null) {
            policy.addAll(p1);
        }
        if ((p2 = this.policiesByHash.get(hash = OpensslTrustAnchorStore.getOpenSSLCAHash(subject))) != null) {
            policy.addAll(p2);
        }
        if (p1 == null && p2 == null) {
            return null;
        }
        return policy;
    }
}

