/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ns;

import eu.emi.security.authn.x509.helpers.ns.NamespacePolicy;
import eu.emi.security.authn.x509.helpers.ns.NamespacesParser;
import eu.emi.security.authn.x509.helpers.ns.OpensslNamespacePolicyImpl;
import eu.emi.security.authn.x509.helpers.ns.ParserUtils;
import eu.emi.security.authn.x509.helpers.trust.OpensslTrustAnchorStore;
import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EuGridPmaNamespacesParser
implements NamespacesParser {
    private static final String VERSION_KEY = "#NAMESPACES-VERSION: ";
    public static final String NS_REGEXP = "^([0-9a-fA-F]{8})\\.namespaces$";
    private static final String SUPPORTED_VERSION = "1.0";
    private String filePath;
    private String hash;
    private String issuer;
    private String subject;
    private boolean permit;

    public EuGridPmaNamespacesParser(String filePath) {
        this.filePath = filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NamespacePolicy> parse() throws IOException {
        this.hash = OpensslTrustAnchorStore.getFileHash(this.filePath, NS_REGEXP);
        if (this.hash == null) {
            throw new IOException("Policy file name " + this.filePath + " is incorrect: it must be formed from 8 charater subject hash and " + "'.namespaces' extension.");
        }
        BufferedReader reader = new BufferedReader(new FileReader(this.filePath));
        try {
            String line;
            StringBuilder fullLine = new StringBuilder();
            int entryNumber = 1;
            ArrayList<NamespacePolicy> ret = new ArrayList<NamespacePolicy>();
            while ((line = reader.readLine()) != null) {
                if ((line = this.stripComments(line)).endsWith("\\") && !line.endsWith("\\\\")) {
                    fullLine.append(line.substring(0, line.length() - 1));
                    continue;
                }
                fullLine.append(line);
                String entry = fullLine.toString().trim();
                if (entry.length() == 0) continue;
                this.handleEntry(entry);
                if (this.issuer.contains("=")) {
                    this.issuer = OpensslNameUtils.normalize(this.issuer);
                }
                String subject = OpensslNameUtils.normalize(this.subject);
                ret.add(new OpensslNamespacePolicyImpl(this.issuer, subject, this.permit, this.filePath + ":" + entryNumber));
                fullLine = new StringBuilder();
                ++entryNumber;
            }
            ArrayList<NamespacePolicy> arrayList = ret;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    protected String stripComments(String from) throws IOException {
        if (from.startsWith(VERSION_KEY)) {
            String version = from.substring(VERSION_KEY.length());
            if (!version.equals(SUPPORTED_VERSION)) {
                throw new IOException("Namespaces policy version " + version + " is unsupported");
            }
            return "";
        }
        char[] chars = from.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            boolean escaped = false;
            if (chars[i] == '\\' && i < chars.length - 1) {
                ++i;
                escaped = true;
            }
            if (chars[i] != '#' || escaped) continue;
            return from.substring(0, i);
        }
        return from;
    }

    protected void handleEntry(String line) throws IOException {
        char[] chars = line.toCharArray();
        int i = 0;
        i += ParserUtils.checkToken("to", chars, 0, false);
        i += this.eatSpaces(chars, i, true);
        i += ParserUtils.checkToken("issuer", chars, i, false);
        if (chars[i += this.eatSpaces(chars, i, true)] == '\"') {
            StringBuilder sb = new StringBuilder();
            i += this.consumeQuoted(chars, i, sb);
            this.issuer = sb.toString();
        } else {
            int r = ParserUtils.checkTokenSoft("self", chars, i, false);
            if (r < 0) {
                throw new IOException("Syntax problem, expected either a quoted issuer DN or the SELF token. Got: " + new String(chars, i, chars.length - i));
            }
            i += r;
            this.issuer = this.hash;
        }
        i += this.eatSpaces(chars, i, true);
        int r = ParserUtils.checkTokenSoft("permit", chars, i, false);
        this.permit = true;
        if (r < 0) {
            r = ParserUtils.checkTokenSoft("deny", chars, i, false);
            this.permit = false;
        }
        if (r < 0) {
            throw new IOException("Syntax problem, expected PERMIT or DENY token. Got: " + new String(chars, i, chars.length - i));
        }
        i += r;
        i += this.eatSpaces(chars, i, true);
        i += ParserUtils.checkToken("subject", chars, i, false);
        i += this.eatSpaces(chars, i, true);
        StringBuilder sb = new StringBuilder();
        i += this.consumeQuoted(chars, i, sb);
        ParserUtils.checkEndOfLine(chars, i);
        this.subject = sb.toString();
    }

    protected int consumeQuoted(char[] chars, int offset, StringBuilder ret) throws IOException {
        if (chars[offset] != '\"' || chars.length < offset + 2) {
            throw new IOException("Syntax problem, expected a quoted string but got: " + new String(chars, offset, chars.length - offset));
        }
        for (int i = 1 + offset; i < chars.length; ++i) {
            boolean escaped = false;
            if (chars[i] == '\\' && i < chars.length - 1) {
                ++i;
                escaped = true;
            }
            if (chars[i] != '\"' || escaped) continue;
            ret.append(chars, offset + 1, i - offset - 1);
            return ret.length() + 2;
        }
        throw new IOException("Syntax problem, quoted string has no closing double qote: " + new String(chars, offset, chars.length - offset));
    }

    private int eatSpaces(char[] string, int offset, boolean atLeastOne) throws IOException {
        int i = 0;
        while (i + offset < string.length && string[i + offset] == ' ') {
            ++i;
        }
        if (atLeastOne && i == 0) {
            throw new IOException("Syntax problem, expected space character(s) here: " + new String(string, offset, string.length - offset));
        }
        return i;
    }
}

