/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.crl;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.pkipath.PlainStoreUtils;
import eu.emi.security.authn.x509.impl.CRLParameters;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.security.auth.x500.X500Principal;

public class PlainCRLStoreSpi
extends CertStoreSpi {
    private ObserversHandler observers;
    private CRLParameters params;
    private final CertificateFactory factory;
    private final PlainStoreUtils utils;
    private Timer timer;
    private long updateInterval;
    private Object intervalLock = new Object();
    private Map<X500Principal, Set<URL>> ca2location;
    private Map<URL, X509CRL> loadedCRLs;

    public PlainCRLStoreSpi(CRLParameters params, Timer t, ObserversHandler observers) throws InvalidAlgorithmParameterException {
        super(params);
        this.observers = observers;
        this.params = params.clone();
        this.loadedCRLs = new HashMap<URL, X509CRL>();
        this.ca2location = new HashMap<X500Principal, Set<URL>>();
        this.utils = new PlainStoreUtils(this.params.getDiskCachePath(), "-crl", this.params.getCrls());
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Can't find certificate fctory for alg. X.509, JDK is misconfigured?", e);
        }
        this.updateInterval = this.params.getCrlUpdateInterval();
        this.timer = t;
        this.update();
        this.scheduleUpdate();
    }

    protected void notifyObservers(String url, StoreUpdateListener.Severity level, Exception e) {
        this.observers.notifyObservers(url, "CRL", level, e);
    }

    protected X509CRL loadCRL(URL url) throws IOException, CRLException, URISyntaxException {
        X509CRL ret2;
        String protocol = url.getProtocol();
        boolean local = false;
        if (protocol.equalsIgnoreCase("file")) {
            local = true;
        }
        try {
            URLConnection conn = url.openConnection();
            if (!local) {
                conn.setConnectTimeout(this.params.getRemoteConnectionTimeout());
                conn.setReadTimeout(this.params.getRemoteConnectionTimeout());
            }
            BufferedInputStream is = new BufferedInputStream(conn.getInputStream());
            ret2 = (X509CRL)this.factory.generateCRL(is);
            ((InputStream)is).close();
            this.notifyObservers(url.toExternalForm(), StoreUpdateListener.Severity.NOTIFICATION, null);
        }
        catch (IOException e) {
            if (!local && this.params.getDiskCachePath() != null) {
                File input = this.utils.getCacheFile(url);
                if (input.exists()) {
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(input));
                    X509CRL ret2 = (X509CRL)this.factory.generateCRL(is);
                    ((InputStream)is).close();
                    this.notifyObservers(url.toExternalForm(), StoreUpdateListener.Severity.WARNING, new IOException("Warning: CRL was not loaded from its URL, but its previously cached copy was loaded from disk file " + input.getPath(), e));
                    return ret2;
                }
                throw e;
            }
            throw e;
        }
        if (!local) {
            this.utils.saveCacheFile(ret2.getEncoded(), url);
        }
        return ret2;
    }

    public List<String> getLocations() {
        return this.utils.getLocations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdateInterval(long newInterval) {
        Object object = this.intervalLock;
        synchronized (object) {
            long old = this.updateInterval;
            this.updateInterval = newInterval;
            if (old <= 0L) {
                this.scheduleUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUpdateInterval() {
        long ret;
        Object object = this.intervalLock;
        synchronized (object) {
            ret = this.updateInterval;
        }
        return ret;
    }

    private synchronized void removeStaleIssuerMapping() {
        for (Map.Entry<X500Principal, Set<URL>> entry : this.ca2location.entrySet()) {
            Iterator<URL> it = entry.getValue().iterator();
            while (it.hasNext()) {
                URL u = it.next();
                if (this.utils.isPresent(u)) continue;
                it.remove();
                this.loadedCRLs.remove(u);
            }
        }
    }

    protected void reloadCRLs(Collection<URL> locations) {
        for (URL location : locations) {
            X509CRL crl;
            try {
                crl = this.loadCRL(location);
            }
            catch (Exception e) {
                this.notifyObservers(location.toExternalForm(), StoreUpdateListener.Severity.ERROR, e);
                continue;
            }
            this.addCRL(crl, location);
        }
    }

    protected synchronized void addCRL(X509CRL crl, URL location) {
        Set<URL> set = this.ca2location.get(crl.getIssuerX500Principal());
        if (set == null) {
            set = new HashSet<URL>();
            this.ca2location.put(crl.getIssuerX500Principal(), set);
        }
        set.add(location);
        this.loadedCRLs.put(location, crl);
    }

    private void update() {
        this.utils.establishWildcardsLocations();
        this.removeStaleIssuerMapping();
        this.reloadCRLs(this.utils.getURLLocations());
        this.reloadCRLs(this.utils.getResolvedWildcards());
    }

    private void scheduleUpdate() {
        long updateInterval = this.getUpdateInterval();
        if (updateInterval > 0L) {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (PlainCRLStoreSpi.this.getUpdateInterval() > 0L) {
                            PlainCRLStoreSpi.this.update();
                        }
                        PlainCRLStoreSpi.this.scheduleUpdate();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            }, updateInterval);
        }
    }

    protected synchronized Collection<X509CRL> getCRLForIssuer(X500Principal issuer) {
        Set<URL> locations = this.ca2location.get(issuer);
        if (locations == null) {
            return Collections.emptyList();
        }
        ArrayList<X509CRL> ret = new ArrayList<X509CRL>(locations.size());
        for (URL location : locations) {
            ret.add(this.loadedCRLs.get(location));
        }
        return ret;
    }

    @Override
    public Collection<? extends Certificate> engineGetCertificates(CertSelector selector) throws CertStoreException {
        return Collections.emptySet();
    }

    @Override
    public Collection<? extends CRL> engineGetCRLs(CRLSelector selectorRaw) throws CertStoreException {
        if (!(selectorRaw instanceof X509CRLSelector)) {
            throw new IllegalArgumentException(this.getClass().getName() + " class supports only X509CRLSelector, got: " + selectorRaw.getClass().getName());
        }
        X509CRLSelector selector = (X509CRLSelector)selectorRaw;
        Collection<X500Principal> issuers = selector.getIssuers();
        ArrayList<X509CRL> ret = new ArrayList<X509CRL>();
        if (issuers == null) {
            return ret;
        }
        for (X500Principal issuer : issuers) {
            Collection<X509CRL> crls = this.getCRLForIssuer(issuer);
            for (X509CRL crl : crls) {
                if (!selector.match(crl)) continue;
                ret.add(crl);
            }
        }
        return ret;
    }

    public void dispose() {
        this.setUpdateInterval(-1L);
    }
}

