/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YearMonthDuration
implements Comparable<YearMonthDuration> {
    private static final String PATTERNSTRING = "(\\-)?P\\d+(Y(\\d+M)?|M)";
    private Duration duration;

    public YearMonthDuration(String duration) {
        if (!duration.matches(PATTERNSTRING)) {
            throw new IllegalArgumentException("The format of the argument isn't correct");
        }
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            this.duration = factory.newDuration(duration);
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        return this.duration.toString();
    }

    @Override
    public int compareTo(YearMonthDuration o) {
        return this.duration.compare(o.duration);
    }

    public boolean equals(Object obj) {
        if (obj instanceof YearMonthDuration) {
            YearMonthDuration object = (YearMonthDuration)obj;
            return this.duration.equals(object.duration);
        }
        return false;
    }

    public int hashCode() {
        return this.duration.hashCode();
    }

    protected Duration getDuration() {
        return this.duration;
    }
}

