/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.simplePDP;

import org.herasaf.xacml.core.api.OrderedPolicyRepository;
import org.herasaf.xacml.core.api.PDP;
import org.herasaf.xacml.core.api.PIP;
import org.herasaf.xacml.core.api.PolicyRetrievalPoint;
import org.herasaf.xacml.core.combiningAlgorithm.policy.PolicyCombiningAlgorithm;
import org.herasaf.xacml.core.combiningAlgorithm.policy.PolicyOrderedCombiningAlgorithm;
import org.herasaf.xacml.core.combiningAlgorithm.policy.PolicyUnorderedCombiningAlgorithm;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.RequestCtx;
import org.herasaf.xacml.core.context.ResponseCtx;
import org.herasaf.xacml.core.context.ResponseCtxFactory;
import org.herasaf.xacml.core.context.StatusCodeComparator;
import org.herasaf.xacml.core.context.impl.AttributeType;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.simplePDP.InitializationException;
import org.herasaf.xacml.core.simplePDP.SimplePDPConfiguration;
import org.herasaf.xacml.core.targetMatcher.TargetMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SimplePDP
implements PDP {
    private final PolicyRetrievalPoint policyRepository;
    private final PIP pip;
    private final PolicyCombiningAlgorithm rootPolicyCombiningAlgorithm;
    private final TargetMatcher targetMatcher;
    private final boolean respectAbandonedEvaluatables;
    private final Logger logger = LoggerFactory.getLogger(SimplePDP.class);
    private static final String MDC_REQUEST_TIME = "org:herasaf:request:xacml:evaluation:requesttime";
    private final StatusCodeComparator statusCodeComparator;

    public SimplePDP(SimplePDPConfiguration simplePDPConfiguration) {
        if ((PolicyOrderedCombiningAlgorithm.class.isInstance(simplePDPConfiguration.getRootCombiningAlgorithm()) && OrderedPolicyRepository.class.isInstance(simplePDPConfiguration.getPolicyRetrievalPoint())) ^ PolicyUnorderedCombiningAlgorithm.class.isInstance(simplePDPConfiguration.getRootCombiningAlgorithm())) {
            String javaVersion;
            this.rootPolicyCombiningAlgorithm = simplePDPConfiguration.getRootCombiningAlgorithm();
            this.policyRepository = simplePDPConfiguration.getPolicyRetrievalPoint();
            this.respectAbandonedEvaluatables = simplePDPConfiguration.isRespectAbandonedEvaluatables();
            this.pip = simplePDPConfiguration.getPip();
            this.targetMatcher = simplePDPConfiguration.getTargetMatcher();
            if (this.pip == null) {
                this.logger.warn("No PIP is set. Attributes that are not present in the request cannot be resolved.");
            }
            if ((javaVersion = System.getProperty("java.version")) != null && (javaVersion.startsWith("1.6.0") || javaVersion.startsWith("1.7.0"))) {
                this.logger.warn("This PDP runs with a Java version > 1.5.0. This may lead to an unspecific behavior when using the data type http://www.w3.org/2001/XMLSchema#time.");
            }
        } else {
            InitializationException ie = new InitializationException("Root combining algorithm and policy repository are not of the same type (type is either ordered or unordered).");
            this.logger.error(ie.getMessage());
            throw ie;
        }
        if (simplePDPConfiguration.getStatusCodeComparator() == null) {
            this.logger.info("Using default status code comparator.");
            this.statusCodeComparator = new StatusCodeComparator();
        } else {
            this.logger.info("Using custom status code comparator.");
            this.statusCodeComparator = simplePDPConfiguration.getStatusCodeComparator();
        }
    }

    public PolicyRetrievalPoint getPolicyRepository() {
        return this.policyRepository;
    }

    public PIP getPIP() {
        return this.pip;
    }

    public PolicyCombiningAlgorithm getRootCombiningAlgorithm() {
        return this.rootPolicyCombiningAlgorithm;
    }

    public ResponseCtx evaluate(RequestCtx request) {
        MDC.put((String)MDC_REQUEST_TIME, (String)String.valueOf(System.currentTimeMillis()));
        this.logger.debug("Evaluating Request: {}", (Object)request.toString());
        EvaluationContext evaluationContext = new EvaluationContext(this.targetMatcher, this.pip, this.respectAbandonedEvaluatables, this.statusCodeComparator);
        if (!this.containsOnlyOneResource(request)) {
            this.logger.error("The request must not contain multiple resources.");
            return this.createResponse(request, DecisionType.INDETERMINATE, evaluationContext);
        }
        DecisionType decision = this.rootPolicyCombiningAlgorithm.evaluateEvaluatableList(request.getRequest(), this.policyRepository.getEvaluatables(request), evaluationContext);
        MDC.remove((String)MDC_REQUEST_TIME);
        return this.createResponse(request, decision, evaluationContext);
    }

    protected ResponseCtx createResponse(RequestCtx request, DecisionType decision, EvaluationContext evaluationContext) {
        return ResponseCtxFactory.create(request.getRequest(), decision, evaluationContext);
    }

    private boolean containsOnlyOneResource(RequestCtx request) {
        if (request.getRequest().getResources().size() > 1) {
            this.logger.error("The request must not contain more than one <Resource> elements.");
            return false;
        }
        if (request.getRequest().getResources().size() == 1) {
            for (AttributeType attr : request.getRequest().getResources().get(0).getAttributes()) {
                if (!"urn:oasis:names:tc:xacml:2.0:resource:scope".startsWith(attr.getAttributeId())) continue;
                if ("Immediate".equals(attr.getAttributeValues().get(0))) {
                    return true;
                }
                if ("Children".equals(attr.getAttributeValues().get(0))) {
                    this.logger.error("The request must not request a decision for multiple resources.");
                    return false;
                }
                if ("Descendants".equals(attr.getAttributeValues().get(0))) {
                    this.logger.error("The request must not request a decision for multiple resources.");
                    return false;
                }
                if ("XPath-expression".equals(attr.getAttributeValues().get(0))) {
                    this.logger.error("The request must not request a decision for multiple resources.");
                    return false;
                }
                if (!"EntireHierarchy".equals(attr.getAttributeValues().get(0))) continue;
                this.logger.error("The request must not request a decision for multiple resources.");
                return false;
            }
            return true;
        }
        return true;
    }
}

