/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.policy.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.herasaf.xacml.core.combiningAlgorithm.rule.AbstractRuleCombiningAlgorithm;
import org.herasaf.xacml.core.converter.URNToRuleCombiningAlgorithmConverter;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.EvaluatableID;
import org.herasaf.xacml.core.policy.impl.CombinerParametersType;
import org.herasaf.xacml.core.policy.impl.DefaultsType;
import org.herasaf.xacml.core.policy.impl.EffectType;
import org.herasaf.xacml.core.policy.impl.EvaluatableIDImpl;
import org.herasaf.xacml.core.policy.impl.ObligationType;
import org.herasaf.xacml.core.policy.impl.ObligationsType;
import org.herasaf.xacml.core.policy.impl.RuleCombinerParametersType;
import org.herasaf.xacml.core.policy.impl.RuleType;
import org.herasaf.xacml.core.policy.impl.TargetType;
import org.herasaf.xacml.core.policy.impl.Variable;
import org.herasaf.xacml.core.policy.impl.VariableDefinitionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@XmlType(name="PolicyType", propOrder={"description", "policyDefaults", "target", "additionalInformation", "obligations"})
public class PolicyType
implements Evaluatable,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Description")
    private String description;
    @XmlElement(name="PolicyDefaults")
    private DefaultsType policyDefaults;
    @XmlElement(name="Target", required=true)
    private TargetType target;
    @XmlElements(value={@XmlElement(name="Rule", type=RuleType.class), @XmlElement(name="VariableDefinition", type=VariableDefinitionType.class), @XmlElement(name="RuleCombinerParameters", type=RuleCombinerParametersType.class), @XmlElement(name="CombinerParameters", type=CombinerParametersType.class)})
    private List<Object> additionalInformation;
    @XmlElement(name="Obligations")
    private ObligationsType obligations;
    @XmlAttribute(name="PolicyId", required=true)
    @XmlSchemaType(name="anyURI")
    private String policyId;
    @XmlAttribute(name="Version")
    private String version;
    @XmlAttribute(name="RuleCombiningAlgId", required=true)
    @XmlJavaTypeAdapter(value=URNToRuleCombiningAlgorithmConverter.class)
    @XmlSchemaType(name="anyURI")
    private AbstractRuleCombiningAlgorithm ruleCombiningAlg;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public DefaultsType getPolicyDefaults() {
        return this.policyDefaults;
    }

    public void setPolicyDefaults(DefaultsType value) {
        this.policyDefaults = value;
    }

    @Override
    public TargetType getTarget() {
        return this.target;
    }

    public void setTarget(TargetType value) {
        this.target = value;
    }

    public List<Object> getAdditionalInformation() {
        if (this.additionalInformation == null) {
            this.additionalInformation = new ArrayList<Object>();
        }
        return this.additionalInformation;
    }

    public ObligationsType getObligations() {
        return this.obligations;
    }

    public void setObligations(ObligationsType value) {
        this.obligations = value;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public void setPolicyId(String value) {
        this.policyId = value;
    }

    public String getVersion() {
        if (this.version == null) {
            return "1.0";
        }
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    @Override
    public AbstractRuleCombiningAlgorithm getCombiningAlg() {
        return this.ruleCombiningAlg;
    }

    public void setCombiningAlg(AbstractRuleCombiningAlgorithm value) {
        this.ruleCombiningAlg = value;
    }

    public List<RuleType> getOrderedRules() {
        ArrayList<RuleType> rules = new ArrayList<RuleType>();
        for (int i = 0; i < this.getAdditionalInformation().size(); ++i) {
            Object obj = this.getAdditionalInformation().get(i);
            if (!(obj instanceof RuleType)) continue;
            rules.add((RuleType)obj);
        }
        return rules;
    }

    public List<RuleType> getUnorderedRules() {
        return this.getOrderedRules();
    }

    public Map<String, Variable> getVariables() {
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        for (Object obj : this.getAdditionalInformation()) {
            if (!(obj instanceof VariableDefinitionType)) continue;
            VariableDefinitionType variable = (VariableDefinitionType)obj;
            variables.put(variable.getVariableId(), variable);
        }
        return variables;
    }

    @Override
    public EvaluatableID getId() {
        return new EvaluatableIDImpl(this.getPolicyId());
    }

    @Override
    public String getEvalutableVersion() {
        return this.getVersion();
    }

    @Override
    public boolean hasObligations() {
        if (this.obligations == null) {
            return false;
        }
        return this.obligations.getObligations().size() > 0;
    }

    @Override
    public List<ObligationType> getContainedObligations(EffectType effect) {
        ArrayList<ObligationType> result = new ArrayList<ObligationType>();
        if (this.obligations != null) {
            List<ObligationType> oblis = this.obligations.getObligations();
            for (int i = 0; i < oblis.size(); ++i) {
                ObligationType obli = oblis.get(i);
                if (obli.getFulfillOn() != effect) continue;
                result.add(obli);
            }
        }
        return result;
    }
}

