/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.context;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.herasaf.xacml.core.NotInitializedException;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.ResponseCtx;
import org.herasaf.xacml.core.context.StatusCode;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.context.impl.MissingAttributeDetailType;
import org.herasaf.xacml.core.context.impl.ObjectFactory;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.context.impl.ResponseType;
import org.herasaf.xacml.core.context.impl.ResultType;
import org.herasaf.xacml.core.context.impl.StatusCodeType;
import org.herasaf.xacml.core.context.impl.StatusDetailType;
import org.herasaf.xacml.core.context.impl.StatusType;
import org.herasaf.xacml.core.utils.DefaultValidationEventHandler;
import org.herasaf.xacml.core.utils.JAXBMarshallerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class ResponseCtxFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseCtxFactory.class);
    private static JAXBContext CONTEXT;
    private static JAXBMarshallerConfiguration CONFIGURATION;
    private static final ObjectFactory OBJECT_FACTORY;

    public static void setJAXBContext(JAXBContext policyContext) {
        CONTEXT = policyContext;
    }

    public static void setJAXBMarshallerConfiguration(JAXBMarshallerConfiguration jmc) {
        CONFIGURATION = jmc;
    }

    private ResponseCtxFactory() {
    }

    public static ResponseCtx create(RequestType req, DecisionType decision, EvaluationContext evaluationContext) {
        ResponseCtx resCtx = ResponseCtxFactory.create(req, decision, evaluationContext.getStatusCode());
        if (evaluationContext.getMissingAttributes().size() > 0) {
            StatusDetailType statusDetail = OBJECT_FACTORY.createStatusDetailType();
            ArrayList<JAXBElement<MissingAttributeDetailType>> missingAttributesJaxb = new ArrayList<JAXBElement<MissingAttributeDetailType>>();
            for (MissingAttributeDetailType madt : evaluationContext.getMissingAttributes()) {
                missingAttributesJaxb.add(OBJECT_FACTORY.createMissingAttributeDetail(madt));
            }
            statusDetail.getContent().addAll(missingAttributesJaxb);
            resCtx.getResponse().getResults().get(0).getStatus().setStatusDetail(statusDetail);
        }
        if (evaluationContext.getObligations().getObligations().size() > 0) {
            resCtx.getResponse().getResults().get(0).setObligations(evaluationContext.getObligations());
        }
        return resCtx;
    }

    public static ResponseCtx create(RequestType req, DecisionType decision, StatusCode code) {
        ResponseType res = OBJECT_FACTORY.createResponseType();
        ResultType result = OBJECT_FACTORY.createResultType();
        if (req.getResources().size() == 1) {
            result.setDecision(decision);
        } else {
            result.setDecision(DecisionType.INDETERMINATE);
        }
        StatusCodeType statusCode = OBJECT_FACTORY.createStatusCodeType();
        statusCode.setValue(code.getValue());
        StatusType status = OBJECT_FACTORY.createStatusType();
        status.setStatusCode(statusCode);
        result.setStatus(status);
        res.getResults().add(result);
        return new ResponseCtx(res);
    }

    private static Unmarshaller createUnmarshaller() throws JAXBException, PropertyException {
        Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
        if (CONFIGURATION.isValidateParsing()) {
            if (CONFIGURATION.getSchema() == null) {
                LOGGER.error("Schema not initialized.");
                throw new NotInitializedException("Schema not initialized");
            }
            unmarshaller.setSchema(CONFIGURATION.getSchema());
        }
        if (CONFIGURATION.getValidationEventHandler() == null) {
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        } else {
            unmarshaller.setEventHandler(CONFIGURATION.getValidationEventHandler());
        }
        return unmarshaller;
    }

    public static ResponseCtx unmarshal(File file) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(file)).getValue();
            return new ResponseCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the file.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the file.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseCtx unmarshal(InputStream inputStream) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(inputStream)).getValue();
            return new ResponseCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input stream.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input stream.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseCtx unmarshal(Reader reader) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(reader)).getValue();
            return new ResponseCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the reader.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the reader.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseCtx unmarshal(URL url) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(url)).getValue();
            return new ResponseCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the url.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the url.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseCtx unmarshal(InputSource inputSource) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(inputSource)).getValue();
            return new ResponseCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input source.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the input source.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseCtx unmarshal(Node node) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(node)).getValue();
            return new ResponseCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the node.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the node.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseCtx unmarshal(Source source) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(source)).getValue();
            return new ResponseCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the source.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the source.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseCtx unmarshal(XMLStreamReader xmlStreamReader) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(xmlStreamReader)).getValue();
            return new ResponseCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml stream reader.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml stream reader.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    public static ResponseCtx unmarshal(XMLEventReader xmlEventReader) throws SyntaxException {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = ResponseCtxFactory.createUnmarshaller();
        }
        catch (PropertyException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to create a JAXB Unmarshaller.", e);
            LOGGER.error(se.getMessage());
            throw se;
        }
        try {
            ResponseType rt = (ResponseType)((JAXBElement)unmarshaller.unmarshal(xmlEventReader)).getValue();
            return new ResponseCtx(rt);
        }
        catch (JAXBException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml event reader.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
        catch (ClassCastException e) {
            SyntaxException se = new SyntaxException("Unable to unmarshal the xml event reader.");
            LOGGER.error(se.getMessage(), (Throwable)e);
            throw se;
        }
    }

    static {
        OBJECT_FACTORY = new ObjectFactory();
    }
}

