/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.validator;

import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.DateUtil;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.validator.AbstractInfoValidator;
import eu.emi.emir.validator.InvalidServiceDescriptionException;
import eu.unicore.util.configuration.ConfigurationException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class RegistrationValidator
extends AbstractInfoValidator {
    private static Logger logger = Log.getLogger((String)"emir.core", RegistrationValidator.class);

    Boolean checkUrl() {
        try {
            if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName()) && this.jo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName()).isEmpty()) {
                logger.error((Object)"Invalid url");
                return false;
            }
            this.valid = true;
        }
        catch (JSONException e) {
            Log.logException((String)"", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    Boolean checkDateTypes() throws InvalidServiceDescriptionException {
        Iterator iterator = this.jo.keys();
        while (iterator.hasNext()) {
            String key = null;
            try {
                key = (String)iterator.next();
                if (!(this.jo.get(key) instanceof JSONObject) || !this.jo.getJSONObject(key).has("$date")) continue;
                DateUtil.toUTCFormat((String)this.jo.getJSONObject(key).getString("$date"));
                this.valid = true;
            }
            catch (Exception e) {
                Log.logException((String)"", (Throwable)new InvalidServiceDescriptionException("invalid date format for the key: " + key, e));
                this.valid = false;
                return false;
            }
        }
        for (ServiceBasicAttributeNames s : ServiceBasicAttributeNames.values()) {
            if (s.getAttributeType() != Date.class) continue;
            try {
                if (!this.jo.has(s.getAttributeName()) || this.jo.get(s.getAttributeName()) instanceof JSONObject && this.jo.getJSONObject(s.getAttributeName()).has("$date")) continue;
                return false;
            }
            catch (JSONException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    Boolean checkExpiryTime() throws InvalidServiceDescriptionException, ConfigurationException, JSONException, ParseException {
        if (this.jo.has(ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.getAttributeName())) {
            if (this.jo.get(ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.getAttributeName()) instanceof JSONObject) {
                if (this.jo.getJSONObject(ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.getAttributeName()).has("$date")) {
                    Date d = DateUtil.toUTCFormat((String)this.jo.getJSONObject(ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.getAttributeName()).getString("$date"));
                    Calendar c = Calendar.getInstance();
                    c.setTime(d);
                    Calendar cMax = Calendar.getInstance();
                    int max_def = 0;
                    try {
                        max_def = EMIRServer.getServerProperties().getIntValue("record.expiryMaximum");
                    }
                    catch (NumberFormatException e) {
                        logger.warn((Object)("Error in reading the configuration property of maximum default expiry days - setting the value to" + max_def + " days"));
                    }
                    cMax.add(5, max_def);
                    if (cMax.compareTo(c) < 0) {
                        String msg = "Failed to validate the service information: Given service expiry- " + c.getTime() + ", exceeds the default maximum- " + cMax.getTime();
                        logger.error((Object)msg);
                        throw new InvalidServiceDescriptionException(msg);
                    }
                    Calendar now = Calendar.getInstance();
                    if (c.compareTo(Calendar.getInstance()) <= 0) {
                        String msg = "Failed to validate the service information: Given service expiry- " + c.getTime() + ", mustn't be less than or equal-to current time - " + now.getTime();
                        logger.error((Object)msg);
                        throw new InvalidServiceDescriptionException(msg);
                    }
                }
            } else {
                String msg = "Failed to validate the service information: invalid date format for the key: " + ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.getAttributeName();
                logger.error((Object)msg);
                this.valid = false;
                throw new InvalidServiceDescriptionException(msg);
            }
        }
        return true;
    }

    boolean checkArrays() {
        for (ServiceBasicAttributeNames s : ServiceBasicAttributeNames.values()) {
            if (s.getAttributeType() != JSONArray.class) continue;
            try {
                if (!this.jo.has(s.getAttributeName()) || this.jo.get(s.getAttributeName()) instanceof JSONArray) continue;
                return false;
            }
            catch (JSONException e) {
                Log.logException((String)(s.getAttributeName() + " is an array-it should be defined as [\"value\",\"value\"...]"), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    Boolean checkMandatoryAttributes() throws InvalidServiceDescriptionException {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("Service Endpoint Record:\n" + this.jo.toString(2) + "\nwith following mandatory Service Endpoint Record attributes are either 'missing', 'NULL', or 'wrongly' defined: \n");
        }
        catch (JSONException e1) {
            logger.error((Object)e1);
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (ServiceBasicAttributeNames s : ServiceBasicAttributeNames.values()) {
            if (!s.isMandatory()) continue;
            try {
                if (!this.jo.has(s.getAttributeName()) && this.jo.isNull(s.getAttributeName())) {
                    sb.append("* " + s.getAttributeName()).append(" is a mandatory attribute, MUST NOT be Null\n");
                    list.add(false);
                }
                if (s.getAttributeType() != JSONArray.class || !this.jo.has(s.getAttributeName())) continue;
                if (!(this.jo.get(s.getAttributeName()) instanceof JSONArray)) {
                    sb.append("* " + s.getAttributeName()).append(" MUST be defined as JSON Array, e.g. [\"value1\",\"value2\"...]");
                    list.add(false);
                }
                if (this.jo.getJSONArray(s.getAttributeName()).length() > 0) continue;
                sb.append("* " + s.getAttributeName()).append(" JSON Array at least contain single element, e.g. [\"value1\",\"value2\"...]");
                list.add(false);
            }
            catch (Exception e) {
                list.add(false);
                Log.logException((String)sb.toString(), (Throwable)e);
                throw new InvalidServiceDescriptionException(sb.toString());
            }
        }
        if (list.contains(false)) {
            logger.error((Object)sb.toString());
            list.clear();
            list = null;
            throw new InvalidServiceDescriptionException(sb.toString());
        }
        list.clear();
        list = null;
        return true;
    }

    Boolean _checkMandatoryAttributes() {
        StringBuilder sb = new StringBuilder("Missing/Invalid mandatory Service Endpoint Record attributes: \n");
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName())) {
            try {
                if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName()) && this.jo.getString(ServiceBasicAttributeNames.SERVICE_ID.getAttributeName()).isEmpty()) {
                    sb.append("Invalid/NULL Service ID\n");
                    list.add(false);
                }
                list.add(true);
            }
            catch (JSONException e) {
                Log.logException((String)"", (Throwable)e);
                return false;
            }
        }
        if (this.jo.has(ServiceBasicAttributeNames.SERVICE_TYPE.getAttributeName())) {
            try {
                if (this.jo.has(ServiceBasicAttributeNames.SERVICE_TYPE.getAttributeName()) && this.jo.getString(ServiceBasicAttributeNames.SERVICE_TYPE.getAttributeName()).isEmpty()) {
                    sb.append("Invalid/NULL Service Type");
                    list.add(false);
                }
                list.add(true);
            }
            catch (JSONException e) {
                Log.logException((String)"", (Throwable)e);
                return false;
            }
        }
        if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName())) {
            try {
                if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName()) && this.jo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName()).isEmpty()) {
                    sb.append("Invalid/NULL Service Endpoint ID\n");
                    list.add(false);
                }
                list.add(true);
            }
            catch (JSONException e) {
                Log.logException((String)"", (Throwable)e);
                list.add(false);
            }
        }
        if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName())) {
            try {
                if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName()) && this.jo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName()).isEmpty()) {
                    sb.append("Invalid/NULL Endpoint URL");
                    list.add(false);
                }
                list.add(true);
            }
            catch (JSONException e) {
                Log.logException((String)"", (Throwable)e);
                return false;
            }
        }
        if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_TECHNOLOGY.getAttributeName())) {
            try {
                if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_TECHNOLOGY.getAttributeName()) && this.jo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_TECHNOLOGY.getAttributeName()).isEmpty()) {
                    sb.append("Invalid/NULL Service Endpoint Technology\n");
                    list.add(false);
                }
                list.add(true);
            }
            catch (JSONException e) {
                Log.logException((String)"", (Throwable)e);
                list.add(false);
            }
        }
        if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACENAME.getAttributeName())) {
            try {
                if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACENAME.getAttributeName()) && this.jo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACENAME.getAttributeName()).isEmpty()) {
                    sb.append("Invalid/NULL Service Endpoint Interface Name\n");
                    list.add(false);
                }
                list.add(true);
            }
            catch (JSONException e) {
                Log.logException((String)"", (Throwable)e);
                list.add(false);
            }
            if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACE_VER.getAttributeName())) {
                try {
                    if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACE_VER.getAttributeName()) && this.jo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACE_VER.getAttributeName()).isEmpty()) {
                        sb.append("Invalid/NULL Service Endpoint Interface Version\n");
                        list.add(false);
                    }
                    list.add(true);
                }
                catch (JSONException e) {
                    Log.logException((String)"", (Throwable)e);
                    list.add(false);
                }
            }
        }
        if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_CAPABILITY.getAttributeName())) {
            try {
                if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_CAPABILITY.getAttributeName()) && this.jo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_CAPABILITY.getAttributeName()).isEmpty()) {
                    sb.append("Invalid/NULL Service Endpoint Interface Name\n");
                    list.add(false);
                }
                list.add(true);
            }
            catch (JSONException e) {
                Log.logException((String)"", (Throwable)e);
                list.add(false);
            }
            if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACE_VER.getAttributeName())) {
                try {
                    if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACE_VER.getAttributeName()) && this.jo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_IFACE_VER.getAttributeName()).isEmpty()) {
                        sb.append("Invalid/NULL Service Endpoint Interface Version\n");
                        list.add(false);
                    }
                    list.add(true);
                }
                catch (JSONException e) {
                    Log.logException((String)"", (Throwable)e);
                    list.add(false);
                }
            }
        }
        if (list.contains(false)) {
            return false;
        }
        return true;
    }

    @Override
    Boolean checkMandatoryEndpointIDAttributes() throws InvalidServiceDescriptionException {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("Service Endpoint Record:\n" + this.jo.toString(2) + "\nwith missing/invalid mandatory Service Endpoint Record attributes: \n");
        }
        catch (JSONException e1) {
            logger.error((Object)e1);
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName())) {
            try {
                if (this.jo.has(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName()) && this.jo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName()).isEmpty()) {
                    sb.append("Invalid/NULL Service Endpoint ID\n");
                    list.add(false);
                }
                list.add(true);
            }
            catch (JSONException e) {
                Log.logException((String)"", (Throwable)e);
                list.add(false);
            }
        }
        if (list.contains(false)) {
            throw new InvalidServiceDescriptionException(sb.toString());
        }
        return true;
    }
}

