/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.security.util;

import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.security.AttributeSourceConfigurator;
import eu.emi.emir.security.AuthorisationException;
import eu.emi.emir.security.IAttributeSource;
import eu.emi.emir.security.SecurityTokens;
import eu.emi.emir.security.SubjectAttributesHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class AttributeSourcesChain
implements IAttributeSource {
    private static final Logger logger = Log.getLogger((String)"emir.security", AttributeSourcesChain.class);
    private List<IAttributeSource> chain;
    private List<String> names;
    private String name;
    private String orderString;
    private String combinerName;
    private CombiningPolicy combiner;
    private Properties properties = null;

    @Override
    public void init(String name) throws Exception {
        this.name = name;
        this.initOrder();
        for (int i = 0; i < this.chain.size(); ++i) {
            NDC.push((String)this.names.get(i));
            this.chain.get(i).init(this.names.get(i));
            NDC.pop();
        }
        this.initCombiningPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubjectAttributesHolder getAttributes(SecurityTokens tokens, SubjectAttributesHolder unused) throws IOException, AuthorisationException {
        SubjectAttributesHolder resultMap = new SubjectAttributesHolder();
        for (IAttributeSource a : this.chain) {
            NDC.push((String)a.getName());
            try {
                SubjectAttributesHolder current = a.getAttributes(tokens, resultMap);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Attribute source " + a.getName() + " returned the following attributes:\n" + current));
                }
                if (this.combiner.combineAttributes(resultMap, current)) continue;
                logger.debug((Object)("Attributes combiner decided to stop processing of attribute sources at " + a.getName() + "."));
                break;
            }
            catch (IOException e) {
                Log.logException((String)("Attribute source <" + a.getClass() + "> not available."), (Throwable)e, (Logger)logger);
            }
            finally {
                NDC.pop();
            }
        }
        return resultMap;
    }

    @Override
    public String getStatusDescription() {
        StringBuilder sb = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        for (IAttributeSource a : this.chain) {
            sb.append(a.getStatusDescription());
            sb.append(lineSep);
        }
        if (this.chain.size() > 1) {
            sb.append("Combining policy: ").append(String.valueOf(this.combiner));
            sb.append(lineSep);
        }
        return sb.toString();
    }

    public List<IAttributeSource> getChain() {
        return Collections.unmodifiableList(this.chain);
    }

    public CombiningPolicy getCombiningPolicy() {
        return this.combiner;
    }

    void merge(Map<String, String[]> master, Map<String, String[]> slave) {
        for (Map.Entry<String, String[]> e : slave.entrySet()) {
            master.put(e.getKey(), e.getValue());
        }
    }

    public void setProperties(Properties p) {
        this.properties = p;
    }

    public void setOrder(String order) {
        this.orderString = order;
    }

    public void setCombiningPolicy(String name) {
        this.combinerName = name;
    }

    private void initOrder() throws Exception {
        this.chain = new ArrayList<IAttributeSource>();
        this.names = new ArrayList<String>();
        if (this.orderString == null) {
            String nn = this.name == null ? "" : "." + this.name;
            throw new IllegalArgumentException("Configuration inconsistent, need to define <emir.security.attributes" + nn + ".order>");
        }
        String[] authzNames = this.orderString.split(" +");
        if (this.properties == null) {
            this.properties = EMIRServer.getRawProperties();
        }
        for (String auth : authzNames) {
            this.chain.add(AttributeSourceConfigurator.configureAttributeSource(auth, this.properties));
            this.names.add(auth);
        }
    }

    private void initCombiningPolicy() {
        if (this.combinerName == null) {
            this.combinerName = "MERGE_LAST_OVERRIDES";
            logger.info((Object)("Using default combining policy " + this.combinerName));
        }
        if ("MERGE_LAST_OVERRIDES".equalsIgnoreCase(this.combinerName)) {
            this.combiner = new MergeLastOverrides();
        } else if ("MERGE".equalsIgnoreCase(this.combinerName)) {
            this.combiner = new Merge();
        } else if ("FIRST_APPLICABLE".equalsIgnoreCase(this.combinerName)) {
            this.combiner = new FirstApplicable();
        } else if ("FIRST_ACCESSIBLE".equalsIgnoreCase(this.combinerName)) {
            this.combiner = new FirstAccessible();
        } else {
            try {
                Object c = Class.forName(this.combinerName).newInstance();
                this.combiner = (CombiningPolicy)c;
            }
            catch (Exception ex) {
                logger.error((Object)("Can't create combining policy <" + this.combinerName + ">. Fallback to default <" + "MERGE_LAST_OVERRIDES" + ">."), (Throwable)ex);
                this.combiner = new MergeLastOverrides();
            }
        }
    }

    @Override
    public String getName() {
        return this.name == null ? "MainChain" : this.name;
    }

    @Override
    public String[] getAcceptedVOs() {
        HashSet<String> accepted = new HashSet<String>();
        for (IAttributeSource as : this.chain) {
            String[] asVos = as.getAcceptedVOs();
            if (asVos == null) continue;
            for (String vo : asVos) {
                accepted.add(vo);
            }
        }
        return accepted.toArray(new String[accepted.size()]);
    }

    public static class Merge
    implements CombiningPolicy {
        public static final String NAME = "MERGE";

        @Override
        public boolean combineAttributes(SubjectAttributesHolder master, SubjectAttributesHolder newAttributes) {
            master.addAllMerging(newAttributes);
            return true;
        }

        public String toString() {
            return NAME;
        }
    }

    public static class MergeLastOverrides
    implements CombiningPolicy {
        public static final String NAME = "MERGE_LAST_OVERRIDES";

        @Override
        public boolean combineAttributes(SubjectAttributesHolder master, SubjectAttributesHolder newAttributes) {
            master.addAllOverwritting(newAttributes);
            return true;
        }

        public String toString() {
            return NAME;
        }
    }

    public static class FirstAccessible
    implements CombiningPolicy {
        public static final String NAME = "FIRST_ACCESSIBLE";

        @Override
        public boolean combineAttributes(SubjectAttributesHolder master, SubjectAttributesHolder newAttributes) {
            if (master.isPresent()) {
                return false;
            }
            master.addAllOverwritting(newAttributes);
            return false;
        }

        public String toString() {
            return NAME;
        }
    }

    public static class FirstApplicable
    implements CombiningPolicy {
        public static final String NAME = "FIRST_APPLICABLE";

        @Override
        public boolean combineAttributes(SubjectAttributesHolder master, SubjectAttributesHolder newAttributes) {
            if (master.isPresent()) {
                return false;
            }
            if (!newAttributes.isPresent()) {
                return true;
            }
            master.addAllOverwritting(newAttributes);
            return false;
        }

        public String toString() {
            return NAME;
        }
    }

    public static interface CombiningPolicy {
        public boolean combineAttributes(SubjectAttributesHolder var1, SubjectAttributesHolder var2);
    }
}

