/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.security;

import eu.emi.emir.client.util.Log;
import eu.emi.emir.security.SecurityTokens;
import eu.emi.emir.security.UserAttributeHandler;
import eu.emi.emir.util.Utilities;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;

public class UserAttributeCallback
implements UserAttributeHandler {
    private static final Logger logger = Log.getLogger((String)"emir.security", UserAttributeCallback.class);
    public static final String USER_PREFERENCES_KEY = UserAttributeCallback.class.getCanonicalName();

    @Override
    public void processUserDefinedAttribute(String name, String nameFormat, XmlObject[] values, SecurityTokens mainToken) {
        HashMap<String, String[]> preferences = (HashMap<String, String[]>)mainToken.getContext().get(USER_PREFERENCES_KEY);
        if (preferences == null) {
            preferences = new HashMap<String, String[]>();
            mainToken.getContext().put(USER_PREFERENCES_KEY, preferences);
        }
        if (this.genericAttributeHandle("group", preferences, name, values, false)) {
            return;
        }
        if (this.genericAttributeHandle("role", preferences, name, values, false)) {
            return;
        }
        if (this.genericAttributeHandle("supplementaryGroups", preferences, name, values, true)) {
            return;
        }
        if (this.genericAttributeHandle("addDefaultGroups", preferences, name, values, false)) {
            return;
        }
        logger.debug((Object)("Ignoring request for unknown attribute named <" + name + ">"));
    }

    private boolean genericAttributeHandle(String processedName, Map<String, String[]> preferences, String name, XmlObject[] xmlValues, boolean multivalued) {
        Object[] values;
        if (!processedName.equals(name)) {
            return false;
        }
        if (!multivalued) {
            values = new String[]{Utilities.extractElementTextAsString(xmlValues[0])};
        } else {
            values = new String[xmlValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = Utilities.extractElementTextAsString(xmlValues[i]);
            }
        }
        preferences.put(processedName, (String[])values);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got request for '" + processedName + "' with value <" + Arrays.toString(values) + ">"));
        }
        return true;
    }
}

