/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.security;

import eu.emi.emir.security.HTTPAuthNTokens;
import eu.emi.emir.security.SignatureStatus;
import java.io.Serializable;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public class SecurityTokens
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String KEY = SecurityTokens.class.getName() + ".key";
    public static final String CTX_LOGIN_HTTP = HTTPAuthNTokens.class.getName() + ".key";
    public static final String CTX_SOAP_ACTION = "REQUEST.soapAction";
    public static final String CTX_SCOPE_KEY = SecurityTokens.class.getName() + ".scope";
    public static final String SCOPE_REQUEST = "request";
    private CertPath user;
    private CertPath consignor;
    private SignatureStatus signatureStatus = SignatureStatus.UNCHECKED;
    private Map<String, Object> context = new HashMap<String, Object>();
    private X500Principal userName;
    private boolean consignorTrusted;
    private boolean trustDelegationValidated;
    private static final String lineSep = System.getProperty("line.separator");

    public void setConsignor(CertPath consignor) {
        this.consignor = consignor;
    }

    public CertPath getConsignor() {
        return this.consignor;
    }

    public X509Certificate getConsignorCertificate() {
        if (this.consignor != null) {
            return (X509Certificate)this.consignor.getCertificates().get(0);
        }
        return null;
    }

    public void setUser(CertPath user) {
        this.user = user;
        this.userName = ((X509Certificate)user.getCertificates().get(0)).getSubjectX500Principal();
    }

    public CertPath getUser() {
        return this.user;
    }

    public void setUserName(X500Principal userName) {
        this.userName = userName;
        this.user = null;
    }

    public X509Certificate getUserCertificate() {
        if (this.user != null) {
            return (X509Certificate)this.user.getCertificates().get(0);
        }
        return null;
    }

    public X500Principal getUserName() {
        if (this.userName != null) {
            return this.userName;
        }
        if (this.user != null) {
            return ((X509Certificate)this.user.getCertificates().get(0)).getSubjectX500Principal();
        }
        return null;
    }

    public String toString() {
        String res;
        StringBuilder sb = new StringBuilder();
        if (this.userName != null) {
            sb.append("User name: ").append(this.userName.getName()).append(lineSep);
        }
        if (this.user != null) {
            sb.append("(have user cert)").append(lineSep);
        }
        if (this.consignor != null) {
            X509Certificate cc = (X509Certificate)this.consignor.getCertificates().get(0);
            sb.append("Consignor DN: ").append(cc.getSubjectX500Principal().getName());
        }
        if (this.signatureStatus != null) {
            sb.append(lineSep + "Message signature status: ").append(this.signatureStatus.toString());
        }
        if ((res = sb.toString()).length() == 0) {
            return super.toString() + " [no details available]";
        }
        return res;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public SignatureStatus getMessageSignatureStatus() {
        return this.signatureStatus;
    }

    public void setMessageSignatureStatus(SignatureStatus status) {
        this.signatureStatus = status;
    }

    public boolean isConsignorTrusted() {
        return this.consignorTrusted;
    }

    public void setConsignorTrusted(boolean consignorTrusted) {
        this.consignorTrusted = consignorTrusted;
    }

    public boolean isTrustDelegationValidated() {
        return this.trustDelegationValidated;
    }

    public void setTrustDelegationValidated(boolean validTrustDelegation) {
        this.trustDelegationValidated = validTrustDelegation;
    }

    public boolean equals(Object otherO) {
        if (otherO == null || !(otherO instanceof SecurityTokens)) {
            return false;
        }
        SecurityTokens other = (SecurityTokens)otherO;
        return true;
    }

    public int hashCode() {
        return super.hashCode() ^ 0x36593265;
    }
}

