/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.security;

import eu.emi.emir.client.util.Log;
import eu.emi.emir.security.AuthNCheckingStrategy;
import eu.emi.emir.security.AuthenticationException;
import eu.emi.emir.security.SecurityManager;
import eu.emi.emir.security.SecurityTokens;
import eu.emi.emir.security.SignatureStatus;
import eu.emi.emir.security.util.ResourceDescriptor;
import org.apache.log4j.Logger;

public class DSignAuthNCheck
implements AuthNCheckingStrategy {
    private static final Logger logger = Log.getLogger((String)"emir.security", DSignAuthNCheck.class);

    public DSignAuthNCheck() {
        logger.debug((Object)"Initialise AuthN check for digital signature.");
    }

    @Override
    public void checkAuthentication(SecurityTokens tokens, String action, ResourceDescriptor d) throws AuthenticationException {
        String soapAction = (String)tokens.getContext().get("REQUEST.soapAction");
        if (soapAction == null) {
            logger.fatal((Object)"SOAP handler pipeline is not set up correctly.");
            throw new AuthenticationException("Internal server error. Please contact the system administrator.");
        }
        logger.debug((Object)("Check authentication for <" + soapAction + ">"));
        if (!SecurityManager.needSignature(soapAction)) {
            return;
        }
        if (SignatureStatus.OK.equals((Object)tokens.getMessageSignatureStatus())) {
            return;
        }
        String msg = "Non repudiation/integrity check failed on <" + d.toString() + ">: signature is required for <" + action + ">";
        logger.info((Object)msg);
        throw new AuthenticationException(msg);
    }
}

