/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.security;

import eu.emi.emir.security.IServerSecurityConfiguration;
import eu.unicore.security.canl.IAuthnAndTrustConfiguration;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertyMD;
import eu.unicore.util.httpclient.ClientProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ClientSecurityProperties
extends ClientProperties {
    @DocumentationReferencePrefix
    public static final String PREFIX = "emir.client.";
    public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();

    public ClientSecurityProperties(Properties p, String trustPrefix, String credPrefix, String clientPrefix) {
        super(p, trustPrefix, credPrefix, clientPrefix);
    }

    public ClientSecurityProperties(Properties p, IAuthnAndTrustConfiguration authAndTrust) {
        super(p, authAndTrust);
    }

    public ClientSecurityProperties(Properties p, String clientPrefix, IAuthnAndTrustConfiguration authAndTrust) {
        super(p, clientPrefix, authAndTrust);
    }

    public ClientSecurityProperties(Properties p, IServerSecurityConfiguration baseSettings) throws ConfigurationException {
        super(ClientSecurityProperties.createClientProperties(p, baseSettings), PREFIX, (IAuthnAndTrustConfiguration)baseSettings);
    }

    private static Properties createClientProperties(Properties p, IServerSecurityConfiguration baseSettings) {
        p.setProperty("emir.client.sslEnabled", baseSettings.isSslEnabled() + "");
        return p;
    }

    static {
        META.put("digitalSigningEnabled", new PropertyMD("false").setDescription("Controls whether signing of key web service requests should be performed."));
        META.putAll(ClientProperties.META);
        META.remove("sslEnabled");
    }
}

