/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.security;

import eu.emi.emir.security.Role;
import eu.emi.emir.security.SecurityTokens;
import eu.emi.emir.security.SubjectAttributesHolder;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Client
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ATTRIBUTE_CREDENTIALS_USERNAME = "creds.username";
    public static final String ATTRIBUTE_CREDENTIALS_PASSWORD = "creds.password";
    public static final String ATTRIBUTE_USER_EMAIL = "user.email";
    private Role role;
    private SecurityTokens secTokens;
    private String distinguishedName;
    private String[] vos;
    private static Client client;
    private SubjectAttributesHolder subjectAttributes;
    private final Map<String, Serializable> extraAttributes = new HashMap<String, Serializable>();

    public Client() {
        this.setSubjectAttributes(new SubjectAttributesHolder());
    }

    public static Client getAnonymousClient() {
        if (client == null) {
            client = new Client();
            client.setDistinguishedName("CN=ANONYMOUS,O=UNKNOWN,OU=UNKNOWN");
            Role role = new Role();
            role.setName("admin");
            client.setRole(role);
        }
        return client;
    }

    public String toString() {
        StringBuilder cInfo = new StringBuilder();
        cInfo.append("Name: ");
        cInfo.append(this.distinguishedName);
        cInfo.append("\nRole: ");
        cInfo.append(this.role);
        if (this.secTokens != null) {
            cInfo.append("\nSecurity tokens: ");
            cInfo.append(this.secTokens);
        }
        return cInfo.toString();
    }

    public SecurityTokens getSecurityTokens() {
        return this.secTokens;
    }

    public void setSecurityTokens(SecurityTokens secTokens) {
        this.secTokens = secTokens;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public String getDistinguishedName() {
        return this.distinguishedName;
    }

    public void setDistinguishedName(String distinguishedName) {
        this.distinguishedName = distinguishedName;
    }

    public Map<String, Serializable> getExtraAttributes() {
        return this.extraAttributes;
    }

    public String getUserEmail() {
        return (String)((Object)this.extraAttributes.get(ATTRIBUTE_USER_EMAIL));
    }

    public void setUserEmail(String email) {
        if (email == null) {
            this.extraAttributes.remove(ATTRIBUTE_USER_EMAIL);
        }
        this.extraAttributes.put(ATTRIBUTE_USER_EMAIL, (Serializable)((Object)email));
    }

    public void setSubjectAttributes(SubjectAttributesHolder subjectAttributes) {
        this.subjectAttributes = subjectAttributes;
    }

    public SubjectAttributesHolder getSubjectAttributes() {
        return this.subjectAttributes;
    }

    public String[] getVos() {
        return this.vos;
    }
}

