/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.security;

import eu.emi.emir.client.util.Log;
import eu.emi.emir.security.IAttributeSource;
import eu.emi.emir.util.PropertyHelper;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AttributeSourceConfigurator {
    private static final Logger logger = Log.getLogger((String)"emir.security", AttributeSourceConfigurator.class);

    public static IAttributeSource configureAttributeSource(String name, Properties properties) throws Exception {
        String dotName = "emir.security.attributes." + name + ".";
        String clazz = properties.getProperty(dotName + "class");
        if (clazz == null) {
            throw new IllegalArgumentException("Inconsistent AuthZ chain definition: expected settings for <" + name + ">");
        }
        logger.debug((Object)("Creating attribute source " + name + " served by class <" + clazz + ">"));
        IAttributeSource auth = (IAttributeSource)Class.forName(clazz).newInstance();
        Map<String, String> params = new PropertyHelper((Map)properties, dotName).getFilteredMap();
        params.remove(dotName + "class");
        AttributeSourceConfigurator.mapParams(auth, params);
        Method propsSetter = AttributeSourceConfigurator.findSetter(auth.getClass(), "properties");
        if (propsSetter != null && propsSetter.getParameterTypes()[0].isAssignableFrom(Properties.class)) {
            propsSetter.invoke((Object)auth, properties);
        }
        return auth;
    }

    private static void mapParams(Object obj, Map<String, String> params) {
        Class<?> clazz = obj.getClass();
        for (Map.Entry<String, String> en : params.entrySet()) {
            String s = en.getKey();
            String paramName = s.substring(s.lastIndexOf(".") + 1);
            Method m = AttributeSourceConfigurator.findSetter(clazz, paramName);
            if (m == null) {
                logger.warn((Object)("Can't map parameter <" + s + ">"));
                continue;
            }
            try {
                AttributeSourceConfigurator.setParam(obj, m, en.getValue());
            }
            catch (Exception ex) {
                logger.warn((Object)("Can't set value <" + en.getValue() + "> for parameter <" + s + ">"));
            }
        }
    }

    private static Method findSetter(Class<?> clazz, String paramName) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equalsIgnoreCase("set" + paramName) || m.getParameterTypes().length <= 0) continue;
            return m;
        }
        return null;
    }

    private static void setParam(Object obj, Method m, String valueString) throws Exception {
        Object arg = valueString;
        if (m.getParameterTypes()[0].isAssignableFrom(Integer.TYPE)) {
            arg = Integer.parseInt(valueString);
        } else if (m.getParameterTypes()[0].isAssignableFrom(Integer.class)) {
            arg = Integer.parseInt(valueString);
        } else if (m.getParameterTypes()[0].isAssignableFrom(Long.TYPE)) {
            arg = Long.parseLong(valueString);
        } else if (m.getParameterTypes()[0].isAssignableFrom(Long.class)) {
            arg = Long.parseLong(valueString);
        } else if (m.getParameterTypes()[0].isAssignableFrom(Boolean.TYPE)) {
            arg = Boolean.valueOf(valueString);
        } else if (m.getParameterTypes()[0].isAssignableFrom(Boolean.class)) {
            arg = Boolean.valueOf(valueString);
        }
        m.invoke(obj, arg);
    }
}

