/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.security;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.security.Client;
import eu.emi.emir.security.Role;
import eu.emi.emir.util.FileWatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

public class ACLFilter
implements ContainerRequestFilter {
    private static Logger logger = Log.getLogger((String)"emir.security", ACLFilter.class);
    private File aclFile = null;
    private FileWatcher watchDog;
    private boolean active;
    private final Map<String, String> acceptedDNs = new HashMap<String, String>();
    private static Set<String> roles = new HashSet<String>();
    @Context
    HttpServletRequest httpRequest;
    private File aclFile2;

    public ACLFilter() throws IOException {
        this(new File(EMIRServer.getServerSecurityProperties().getACLConfigurationFile()));
    }

    public ACLFilter(File aclFile) {
        this.aclFile = aclFile;
        if (!aclFile.exists()) {
            logger.warn((Object)("ACL not active: file <" + aclFile + "> does not exist"));
            this.active = false;
            this.watchDog = null;
            return;
        }
        this.active = true;
        logger.info((Object)("EMIR using ACL file " + aclFile));
        this.readACL();
        try {
            this.watchDog = new FileWatcher(aclFile, new Runnable(){

                @Override
                public void run() {
                    ACLFilter.this.readACL();
                }
            });
            this.watchDog.schedule(3000, TimeUnit.MILLISECONDS);
        }
        catch (FileNotFoundException e) {
            Log.logException((String)("Invalid file path: " + aclFile), (Throwable)e, (Logger)logger);
        }
    }

    public ContainerRequest filter(ContainerRequest request) throws WebApplicationException {
        Client client = null;
        Role role = new Role();
        Boolean b = EMIRServer.getServerSecurityProperties().isSslEnabled();
        String path = request.getPath();
        if (b.booleanValue() && EMIRServer.getServerSecurityProperties().isACLAccessControlEnabled()) {
            X509Certificate[] certArr = (X509Certificate[])this.httpRequest.getAttribute("javax.servlet.request.X509Certificate");
            String userName = certArr[0].getSubjectX500Principal().getName();
            if (path.equalsIgnoreCase("serviceadmin")) {
                client = this.checkAccess(userName);
            } else {
                client = new Client();
                client.setDistinguishedName(userName);
            }
        }
        if (logger.isDebugEnabled() && !request.getPath().equalsIgnoreCase("favicon.ico")) {
            logger.debug((Object)("Accessing resource: '" + request.getPath() + "' with DN: " + client.getDistinguishedName()));
        }
        this.httpRequest.setAttribute("client", client);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Client checkAccess(String userName) throws WebApplicationException {
        Client client = null;
        String msg = "Admin access denied!\n\nTo allow access for this certificate, the distinguished name \n" + userName + "\nneeds to be entered into the ACL file." + "\nPlease check the EMIR's ACL file!\n\n";
        Map<String, String> map = this.acceptedDNs;
        synchronized (map) {
            if (!this.acceptedDNs.containsKey(userName)) {
                logger.info((Object)msg);
                throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).entity((Object)msg).build());
            }
            client = new Client();
            client.setDistinguishedName(userName);
            String roleName = this.acceptedDNs.get(userName);
            logger.debug((Object)roles.contains(roleName));
            if (roleName == null || !roles.contains(roleName)) {
                throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).entity((Object)msg).build());
            }
            client.setRole(new Role(roleName, ""));
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readACL() {
        Map<String, String> map = this.acceptedDNs;
        synchronized (map) {
            BufferedReader br = null;
            try {
                String theLine;
                br = new BufferedReader(new FileReader(this.aclFile));
                this.acceptedDNs.clear();
                while ((theLine = br.readLine()) != null) {
                    String line = theLine.trim();
                    if (line.startsWith("#") || line.trim().equals("")) continue;
                    try {
                        String[] pair = line.split("::");
                        X500Principal p = new X500Principal(pair[0].trim());
                        if (this.acceptedDNs.containsKey(p.getName())) {
                            String message = "Duplicate access for this DN: " + line;
                            message = message + "\n First one will be use!!!";
                            logger.warn((Object)message);
                            continue;
                        }
                        this.acceptedDNs.put(p.getName(), pair[1].trim());
                        logger.info((Object)("Allowing " + pair[1].trim() + " access for <" + line + ">"));
                    }
                    catch (Exception ex) {
                        logger.warn((Object)("Invalid entry <" + line + ">"), (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                logger.fatal((Object)"ACL file read error!", (Throwable)ex);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        roles.add("serviceowner");
        roles.add("admin");
    }
}

