/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.resource;

import eu.emi.emir.client.util.Log;
import eu.emi.emir.core.ServiceColManager;
import eu.eu_emi.emiregistry.QueryResult;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/services")
public class ServiceCollectionResource {
    Logger logger = Log.getLogger((String)"emir.core", ServiceCollectionResource.class);
    private ServiceColManager col = new ServiceColManager();

    @GET
    @Produces(value={"application/json"})
    @Path(value="/urls")
    public Response getServiceEndPoints() throws WebApplicationException, JSONException {
        JSONArray jArr = null;
        try {
            jArr = this.col.getServiceReferences();
        }
        catch (Exception e) {
            Log.logException((String)"Error in doing query for service urls in JSON format", (Throwable)e, (Logger)this.logger);
            JSONObject jErr = new JSONObject();
            jErr.put("error", (Object)e.getCause());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jErr).build());
        }
        if (jArr.length() == 0) {
            return Response.ok((Object)jArr).status(Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)jArr).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/types")
    public Response getServiceTypes() throws WebApplicationException, JSONException {
        JSONArray jArr = null;
        try {
            jArr = this.col.getDistinctTypes();
        }
        catch (Exception e) {
            Log.logException((String)"Error in doing query for service types in JSON format", (Throwable)e, (Logger)this.logger);
            JSONObject jErr = new JSONObject();
            jErr.put("error", (Object)e.getCause());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jErr).build());
        }
        if (jArr.length() == 0) {
            return Response.ok((Object)jArr).status(Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)jArr).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response queryWithParamsForJSON(@Context UriInfo ui) throws WebApplicationException, JSONException {
        MultivaluedMap queryParams = ui.getQueryParameters();
        Set s = queryParams.keySet();
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String key : s) {
            m.put(key, queryParams.getFirst((Object)key));
        }
        JSONArray jArr = null;
        try {
            jArr = this.col.queryForJSON(m);
        }
        catch (Exception e) {
            Log.logException((String)"Error in doing query for services in JSON format", (Throwable)e, (Logger)this.logger);
            JSONObject jErr = new JSONObject();
            jErr.put("error", (Object)e.getCause());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jErr).build());
        }
        if (jArr.length() == 0) {
            return Response.ok((Object)jArr).status(Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)jArr).build();
    }

    @GET
    @Produces(value={"application/xml", "text/xml"})
    public Response queryWithParamsForXML(@Context UriInfo ui) throws WebApplicationException {
        MultivaluedMap queryParams = ui.getQueryParameters();
        Set s = queryParams.keySet();
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String key : s) {
            m.put(key, queryParams.getFirst((Object)key));
        }
        QueryResult qr = null;
        try {
            qr = this.col.queryForXML(m);
        }
        catch (Exception e) {
            Log.logException((String)"Error in doing query for services in XML format", (Throwable)e, (Logger)this.logger);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("<error>" + e.getCause().toString() + "</error>")).build());
        }
        if (qr.getCount() == BigInteger.ZERO) {
            return Response.ok((Object)qr).status(Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)qr).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response richQueryForJSON(JSONObject queryDocument, @Context UriInfo ui) throws WebApplicationException, JSONException {
        MultivaluedMap queryParams = ui.getQueryParameters();
        Set s = queryParams.keySet();
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String key : s) {
            m.put(key, queryParams.getFirst((Object)key));
        }
        JSONArray jArr = null;
        try {
            jArr = this.col.queryForJSON(queryDocument, m);
        }
        catch (Exception e) {
            Log.logException((String)"Error in doing query for services in JSON format", (Throwable)e, (Logger)this.logger);
            JSONObject jErr = new JSONObject();
            jErr.put("error", (Object)e.getCause());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jErr).build());
        }
        if (jArr.length() == 0) {
            return Response.ok((Object)jArr).status(Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)jArr).build();
    }

    @POST
    @Produces(value={"application/xml"})
    @Consumes(value={"application/json"})
    public Response richQueryForXML(JSONObject queryDocument, @Context UriInfo ui) throws WebApplicationException {
        MultivaluedMap queryParams = ui.getQueryParameters();
        Set s = queryParams.keySet();
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String key : s) {
            m.put(key, queryParams.getFirst((Object)key));
        }
        QueryResult jArr = null;
        try {
            jArr = this.col.queryForXML(queryDocument, m);
        }
        catch (Exception e) {
            Log.logException((String)"Error in doing query for services in XML format", (Throwable)e, (Logger)this.logger);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("<error>" + e.getCause().toString() + "</error>")).build());
        }
        if (jArr == null) {
            return Response.ok().status(Response.Status.NO_CONTENT).build();
        }
        if (jArr.getCount() == BigInteger.ZERO) {
            return Response.ok((Object)jArr).status(Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)jArr).build();
    }

    @Deprecated
    @GET
    @Path(value="/query.xml")
    @Produces(value={"application/xml", "text/xml"})
    public Response queryXml(@Context UriInfo ui) throws WebApplicationException {
        MultivaluedMap queryParams = ui.getQueryParameters();
        Set s = queryParams.keySet();
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String key : s) {
            m.put(key, queryParams.getFirst((Object)key));
        }
        QueryResult qr = null;
        try {
            qr = this.col.queryForXML(m);
        }
        catch (Exception e) {
            Log.logException((String)"Error executing query for services in XML format", (Throwable)e, (Logger)this.logger);
            throw new WebApplicationException((Throwable)e);
        }
        if (qr.getCount() == BigInteger.ZERO) {
            return Response.ok((Object)qr).status(Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)qr).build();
    }

    @Deprecated
    @GET
    @Path(value="/pagedquery")
    @Produces(value={"application/json"})
    public Response pagedQuery(@Context UriInfo ui) throws WebApplicationException, JSONException {
        MultivaluedMap queryParams = ui.getQueryParameters();
        Set s = queryParams.keySet();
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String key : s) {
            m.put(key, queryParams.getFirst((Object)key));
        }
        JSONArray jArr = null;
        try {
            jArr = this.col.pagedQueryForJSON(m);
        }
        catch (Exception e) {
            Log.logException((String)"Error executing paged query", (Throwable)e, (Logger)this.logger);
            JSONObject jErr = new JSONObject();
            jErr.put("error", (Object)e.getCause());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jErr).build());
        }
        if (jArr.length() == 0) {
            return Response.ok((Object)jArr).status(Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)jArr).build();
    }

    @Deprecated
    @GET
    @Path(value="/pagedquery")
    @Produces(value={"application/xml"})
    public Response pagedQueryGlue2(@Context UriInfo ui) throws WebApplicationException, JSONException {
        MultivaluedMap queryParams = ui.getQueryParameters();
        Set s = queryParams.keySet();
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String key : s) {
            m.put(key, queryParams.getFirst((Object)key));
        }
        QueryResult qr = null;
        try {
            qr = this.col.queryForXML(m);
        }
        catch (Exception e) {
            Log.logException((String)"Error executing paged query in XML format", (Throwable)e, (Logger)this.logger);
            JSONObject jErr = new JSONObject();
            jErr.put("error", (Object)e.getCause());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jErr).build());
        }
        if (qr.getCount() == BigInteger.ZERO) {
            return Response.ok((Object)qr).status(Response.Status.NO_CONTENT).build();
        }
        return Response.ok((Object)qr).build();
    }
}

