/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.resource;

import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.DateUtil;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.core.ServiceAdminManager;
import eu.emi.emir.db.ExistingResourceException;
import eu.emi.emir.event.Event;
import eu.emi.emir.event.EventDispatcher;
import eu.emi.emir.exception.UnknownServiceException;
import eu.emi.emir.security.Client;
import eu.emi.emir.validator.InvalidServiceDescriptionException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/serviceadmin")
public class ServiceAdminResource {
    private static Logger logger = Log.getLogger((String)"emir.core", ServiceAdminResource.class);
    private ServiceAdminManager serviceAdmin = new ServiceAdminManager();
    @Context
    HttpServletRequest req;

    protected String getUserPrincipalName() {
        String p = null;
        if (!this.req.isSecure()) {
            return "";
        }
        X509Certificate[] cert = (X509Certificate[])this.req.getAttribute("javax.servlet.request.X509Certificate");
        p = cert[0].getSubjectDN().getName();
        return p;
    }

    @GET
    @Produces(value={"application/json"})
    public JSONObject getServicebyID(@Context UriInfo infos) throws WebApplicationException, JSONException {
        JSONObject result;
        try {
            String id = this.extractServiceEndpointIDFromUri(infos);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Finding Service by Endpoint ID: " + id));
            }
            result = this.serviceAdmin.findServiceByEndpointID(this.extractServiceEndpointIDFromUri(infos));
        }
        catch (Exception e) {
            Log.logException((String)"Error in finding SER by Endpoint ID", (Throwable)e, (Logger)logger);
            JSONObject jErr = new JSONObject();
            jErr.put("error", (Object)e.getCause());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jErr).build());
        }
        return result;
    }

    private String extractServiceEndpointIDFromUri(UriInfo infos) throws IllegalArgumentException {
        String attrName;
        String key;
        MultivaluedMap mm = infos.getQueryParameters();
        String string = key = mm.containsKey((Object)(attrName = ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName())) ? attrName : "unknown";
        if (key == "unknown") {
            Log.logException((String)"Error in getting Service by ID", (Throwable)new IllegalArgumentException("illegal argument"), (Logger)logger);
            throw new IllegalArgumentException();
        }
        String value = (String)mm.getFirst((Object)ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName());
        return value;
    }

    public Response registerService(JSONObject serviceInfo) throws WebApplicationException, JSONException {
        Integer length = serviceInfo.length();
        if (length <= 0 || length > 100) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        try {
            Client c = (Client)this.req.getAttribute("client");
            if (!EMIRServer.getServerSecurityProperties().isSslEnabled() && c == null) {
                c = Client.getAnonymousClient();
            }
            serviceInfo.put(ServiceBasicAttributeNames.SERVICE_OWNER_DN.getAttributeName(), (Object)c.getDistinguishedName());
            JSONObject res = this.serviceAdmin.addService(serviceInfo);
            return Response.ok((Object)res).build();
        }
        catch (ExistingResourceException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)serviceInfo).build();
        }
        catch (Exception e) {
            JSONObject jErr = new JSONObject();
            jErr.put("error", (Object)e.getCause());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jErr).build());
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerServices(JSONArray serviceInfos) throws WebApplicationException, InterruptedException, JSONException {
        Long max = EMIRServer.getServerProperties().getLongValue("record.maximum");
        if ((long)serviceInfos.length() > max) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new String("Number of entries/json objects in the array must not exceed: " + max)).build();
        }
        JSONObject serviceInfo = null;
        JSONArray arr = new JSONArray();
        JSONArray errorArray = new JSONArray();
        for (int i = 0; i < serviceInfos.length(); ++i) {
            try {
                serviceInfo = serviceInfos.getJSONObject(i);
                Integer length = serviceInfo.length();
                if (length <= 0 || length > 100) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                String serviceID = serviceInfo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName());
                String messageTime = "";
                if (serviceInfo.has(ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName())) {
                    messageTime = serviceInfo.getJSONObject(ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName()).getString("$date");
                }
                Client c = (Client)this.req.getAttribute("client");
                if (!EMIRServer.getServerSecurityProperties().isSslEnabled() && c == null) {
                    c = Client.getAnonymousClient();
                }
                JSONObject res = null;
                if (c.getRole().getName().equalsIgnoreCase("admin")) {
                    if (!serviceInfo.has(ServiceBasicAttributeNames.SERVICE_OWNER_DN.getAttributeName())) {
                        serviceInfo.put(ServiceBasicAttributeNames.SERVICE_OWNER_DN.getAttributeName(), (Object)c.getDistinguishedName());
                    }
                    if (this.serviceAdmin.checkMessageGenerationTime(messageTime, serviceID)) {
                        res = this.serviceAdmin.addService(serviceInfo);
                    }
                } else if (this.serviceAdmin.checkMessageGenerationTime(messageTime, serviceID)) {
                    serviceInfo.put(ServiceBasicAttributeNames.SERVICE_OWNER_DN.getAttributeName(), (Object)c.getDistinguishedName());
                    res = this.serviceAdmin.addService(serviceInfo);
                }
                if (res == null) continue;
                arr.put(res);
                continue;
            }
            catch (ExistingResourceException e) {
                errorArray.put((Object)("The service with id:" + serviceInfo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName()) + "already exists"));
                continue;
            }
            catch (InvalidServiceDescriptionException e) {
                errorArray.put((Object)("Error occured while updating/creating the service: " + e.getMessage()));
                continue;
            }
            catch (Exception e) {
                JSONObject jErr = new JSONObject();
                jErr.put("error", (Object)e.getCause());
                Log.logException((String)"Error in registering the information", (Throwable)e, (Logger)logger);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jErr).build());
            }
        }
        if (arr.length() > 0) {
            EventDispatcher.notifyRecievers(new Event("service_add", arr));
        }
        if (errorArray.length() > 0) {
            logger.warn((Object)("Errors while registring the service information\n" + errorArray.toString(2)));
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)errorArray).build();
        }
        return Response.ok((Object)arr).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateServices(JSONArray serviceInfos) throws WebApplicationException, JSONException {
        try {
            JSONArray arr = new JSONArray();
            JSONArray errorArray = new JSONArray();
            Client c = (Client)this.req.getAttribute("client");
            if (!EMIRServer.getServerSecurityProperties().isSslEnabled() && c == null) {
                c = Client.getAnonymousClient();
            }
            for (int i = 0; i < serviceInfos.length(); ++i) {
                JSONObject res;
                JSONObject serviceInfo = serviceInfos.getJSONObject(i);
                String owner = c.getDistinguishedName();
                String sendpointID = serviceInfo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName());
                serviceInfo.put(ServiceBasicAttributeNames.SERVICE_OWNER_DN.getAttributeName(), (Object)c.getDistinguishedName());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("updating service by ID: " + sendpointID + ", Owned by: " + owner));
                }
                String messageTime = "";
                if (serviceInfo.has(ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName())) {
                    messageTime = serviceInfo.getJSONObject(ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName()).getString("$date");
                }
                if (c.getRole().getName().equalsIgnoreCase("admin") && this.serviceAdmin.checkMessageGenerationTime(messageTime, sendpointID)) {
                    try {
                        res = this.serviceAdmin.updateService(serviceInfo);
                        arr.put((Object)res);
                        continue;
                    }
                    catch (UnknownServiceException e) {
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                    }
                    catch (WebApplicationException e) {
                        errorArray.put((Object)("Error occured while updating the service: " + serviceInfo));
                        continue;
                    }
                    catch (InvalidServiceDescriptionException e) {
                        errorArray.put((Object)("Error occured while updating/creating the service: " + e.getMessage()));
                        continue;
                    }
                }
                if (owner != null && this.serviceAdmin.checkOwner(owner, serviceInfo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName())) && this.serviceAdmin.checkMessageGenerationTime(messageTime, sendpointID)) {
                    try {
                        res = this.serviceAdmin.updateService(serviceInfo);
                        arr.put((Object)res);
                        continue;
                    }
                    catch (UnknownServiceException e) {
                        Log.logException((String)("Service with endpoint id: '" + serviceInfo.get(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName()) + "' does not exist"), (Throwable)e, (Logger)logger);
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                    }
                    catch (WebApplicationException e) {
                        errorArray.put((Object)("Error occured while updating the service: " + serviceInfo));
                        continue;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Service with endpointID: " + serviceInfo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName()) + " does not exist or the update message is too old."));
                }
                String message = "Access denied for DN - " + owner + " to update service with the endpointID - " + sendpointID;
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)message).build();
            }
            if (arr.length() > 0) {
                EventDispatcher.notifyRecievers(new Event("service_update", arr));
            }
            if (errorArray.length() > 0) {
                logger.warn((Object)("Error while registering/updating the service information: \n" + errorArray.toString(2)));
                return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)errorArray).build();
            }
            return Response.ok((Object)arr).build();
        }
        catch (Exception e) {
            Log.logException((String)"Error in updating the services", (Throwable)e, (Logger)logger);
            JSONObject jErr = new JSONObject();
            jErr.put("error", (Object)e.getCause());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jErr).build());
        }
    }

    @DELETE
    public Response deleteService(@Context UriInfo infos) throws WebApplicationException, JSONException {
        block7: {
            String sendpointID = null;
            try {
                Client c = (Client)this.req.getAttribute("client");
                if (!EMIRServer.getServerSecurityProperties().isSslEnabled() && c == null) {
                    c = Client.getAnonymousClient();
                }
                String owner = c.getDistinguishedName();
                sendpointID = this.extractServiceEndpointIDFromUri(infos);
                String messageTime = this.extractServiceDateFromUri(infos);
                if (EMIRServer.getServerProperties().isGlobalEnabled().booleanValue() && messageTime == "unknown") {
                    messageTime = DateUtil.toUTCFormat((Date)new Date());
                }
                logger.debug((Object)("deleting service by Endpoint ID: " + sendpointID + ", Owned by: " + owner));
                if (c.getRole().getName().equalsIgnoreCase("admin")) {
                    this.serviceAdmin.removeService(sendpointID, messageTime);
                    break block7;
                }
                if (owner != null && this.serviceAdmin.checkOwner(owner, sendpointID) && this.serviceAdmin.checkMessageGenerationTime(messageTime, sendpointID)) {
                    this.serviceAdmin.removeService(sendpointID, messageTime);
                    break block7;
                }
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("Access denied for DN - " + owner + " to remove service with the ID - " + sendpointID)).build();
            }
            catch (IllegalArgumentException e) {
                Log.logException((String)("Missing/Invalid query parameter: The delete request must contain a query parameter: /serviceadmin?" + ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName() + " = <SERVICE ENDPOINT ID>"), (Throwable)e, (Logger)logger);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Missing/Invalid query parameter: The delete request must contain a query parameter: /serviceadmin?" + ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName() + " = <SERVICE ENDPOINT ID>")).build();
            }
            catch (Exception e) {
                Log.logException((String)"Error in deleting the service", (Throwable)e, (Logger)logger);
                JSONObject jErr = new JSONObject();
                jErr.put("error", (Object)e.getCause());
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jErr).build());
            }
        }
        return Response.ok().build();
    }

    private String extractServiceDateFromUri(UriInfo infos) throws IllegalArgumentException {
        String attrName;
        String key;
        MultivaluedMap mm = infos.getQueryParameters();
        String string = key = mm.containsKey((Object)(attrName = ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName())) ? attrName : "unknown";
        if (key == "unknown") {
            return "unknown";
        }
        String value = (String)mm.getFirst((Object)ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName());
        return value;
    }
}

