/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.resource;

import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.Log;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;

@Path(value="/model")
public class ModelResource {
    @Context
    HttpServletRequest req;
    private static JSONArray jo;

    public ModelResource() {
        InputStream is = ModelResource.class.getResourceAsStream("servicemodel.json");
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)is, (Writer)writer);
            jo = new JSONArray(writer.toString());
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
    }

    @Produces(value={"text/html", "application/json"})
    @GET
    public Response getModel() throws WebApplicationException {
        String[] str;
        for (String s : str = this.req.getHeader("Accept").split(",")) {
            if (!s.contains("json")) continue;
            return Response.ok((Object)jo).build();
        }
        StringBuilder b = new StringBuilder();
        b.append("<html>");
        b.append("<head>");
        b.append("</head>");
        b.append("<h1>EMI Registry Service Model</h1>");
        b.append("<body>");
        b.append("<table border = \"1\">");
        b.append("<tr>");
        b.append("<td>");
        b.append("<b>Attribute Name</b>");
        b.append("</td>");
        b.append("<td>");
        b.append("<b>Description</b>");
        b.append("</td>");
        b.append("</tr>");
        ServiceBasicAttributeNames[] sn = ServiceBasicAttributeNames.values();
        for (int i = 0; i < sn.length; ++i) {
            b.append("<tr>");
            b.append("<td>").append(sn[i].getAttributeName()).append("</td>");
            b.append("<td>").append(sn[i].getAttributeDesc()).append("</td>");
            b.append("</tr>");
            b.append("\n");
        }
        b.append("</table>");
        b.append("\n\n");
        b.append("<p>Raw JSON document to register and update the services</p>");
        b.append("<textarea name=\"comments\" rows=\"30\" cols=\"80\">");
        try {
            b.append(jo.toString(2));
        }
        catch (JSONException e) {
            Log.logException((String)"", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        b.append("</textarea>");
        b.append("</body></html>");
        return Response.ok((Object)b.toString()).build();
    }
}

